/**
 * @author pritam.patil
 * refund History Details Grid 
 */
Ext.define('Academia.view.completion.completionlistforms.common.CompletionRefundHistoryGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.completionrefundhistorygrid',
    title : getCompletionModuleTranslation('REFUND_HISTORY'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getCompletionModuleTranslation('PAYMENT_VOUCHER'),
        dataIndex: 'paymentVoucher',
        sortable: true,
        flex: .3
    },{
        header: getCompletionModuleTranslation('REFUND'),
        dataIndex: 'refund',
        sortable: true,
        flex: .2,
        
        renderer : function(value, metadata, record){
            
            if(!isEmpty(record.get('studentPendingPaymentRefundHeadWiseDetails'))){
            		return record.get('studentPendingPaymentRefundHeadWiseDetails')[0].feeAmount;
            	}else{
            		return value;
            	}
        }
           
       
    }, {
        header: getCompletionModuleTranslation('FEE_HEAD'),
        dataIndex: 'feeHead',
        sortable: true,
        flex: .2,
        renderer : function(value, metadata, record){
        	
            if(!isEmpty(record.get('studentPendingPaymentRefundHeadWiseDetails'))){
            		return record.get('studentPendingPaymentRefundHeadWiseDetails')[0].feeHeadName;
            	}else{
            		return value;
            	}
            }
    }, {
        header: getCompletionModuleTranslation('REFUNDED_DATE'),
        dataIndex: 'paymentDate',
        sortable: true,
        flex: .2,
        xtype:'datecolumn',
		renderer:function(date) {
			return dateRender(date);
		}
    },  {
        header: getCompletionModuleTranslation('REFUNDED_AMOUNT'),
        dataIndex: 'amount',
        sortable: true,
        flex: .1
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.paymentandrefund.RefundHistoryStore');
    }

});


