/**
 * @author pritam.patil
 * Issue Certificates Details Grid 
 */
Ext.define('Academia.view.completion.completionlistforms.common.IssueCertificatesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.issuecertificatesgrid',
    border: true,
    viewConfig: {
        stripeRows: true
    },
    selType:'checkboxmodel',
    multiSelect:true,
   
    columns: [{
        header: getCompletionModuleTranslation('CERTIFICATE_NAME'),
        dataIndex: 'certificate',
        sortable: true,
        flex: .2
    },{
        header: getCompletionModuleTranslation('STATUS'),
        dataIndex: 'status',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	if(value === 'PENDING'){
        		return  getCompletionModuleTranslation('PENDING');
        	}else if(value === 'IN_PROGRESS'){
        		return  getCompletionModuleTranslation('IN_PROGRESS');
        	}else if (value === 'COMPLETED'){
        		return  getCompletionModuleTranslation('COMPLETED');
        	}
        }
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.completion.completionform.IssueCertificatesGrids');
    }

});
