/**
 * @author sachin.bangar
 * This form is used for Manage CheckList Item
 */
Ext.define('Academia.view.completion.setup.ManageCheckListItemForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.managechecklistitemform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'hidden',
        itemId: 'checklist_hidden_field',
        name: 'id'
    }, {
        xtype: 'textfield',
        fieldLabel: getCompletionModuleTranslation('CHECKLIST_ITEM_CODE'),
        name: 'code',
        allowBlank : false
    }, {
        xtype: 'textfield',
        fieldLabel: getCompletionModuleTranslation('CHECKLIST_ITEM'),
        name: 'value',
        allowBlank : false
    }, {
        xtype: 'fieldcontainer',
       ///                     fieldLabel : 'pritam',
        width: '100%',
        style : {
        	marginTop : '15px',
        	marginLeft : '-1px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});