/**
 * @author Akshay.Kalbhor
 * This is the basic set-up panel for Manage Completion CheckList
 */
Ext.define('Academia.view.completion.setup.ManageCompletionSearchPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.managecompletionsearchpanel',
    //autoScroll: true,
    title: 'Completion Checklist',
    border: true,
    frame: false,
    cls:'customSearchPanel',
    bodyCls: 'manage-completion-search-panel',
	items : [{
		xtype: 'fieldset',
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				itemId: 'programCombo',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store: 'Academia.store.common.ProgramByAcademyLocationStore',
		        displayField: 'valueCode',
		        valueField: 'id',
		        forceSelection:true,
		        queryParam:'programName',
				minChars:3,
		        //queryMode: 'local',
		        autoload: false
			}, {
				xtype: 'customcombobox',
				itemId: 'batchCombo',
				fieldLabel: getCommonTranslation('BATCH'),
				store: 'Academia.store.common.BatchesByProgramId',
	            displayField: 'value',
	            valueField: 'id',
	            queryMode: 'local',
	            disabled : true,
	            autoload: false
			}]	
		}]
	}, {
		xtype: 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'completionChecklistSearch',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			margin: '0 44 0 0'
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'completionChecklistReset',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
	
});