/**
 * This form is used to display checklist of pending items.
 * @author Pritam.Patil
 */
Ext.define('Academia.view.completion.setup.ShowFeesDuePopUp', {
    extend: 'Ext.window.Window',
    alias: 'widget.showfeesduepopup',
    border : false,
    frame : false,
    modal: true,
    width:'35%',
    height:'30%',
    items: [{
    	  xtype: 'dataview',
          itemId: 'checkListItemId',
          store: Ext.create('Ext.data.Store', {
          	fields: ['student','mobileNumber','email','program','effectiveDate','pendingDocuments','returnDocuments',
          	         'issueCertificates','enrolled_in','totalPendingPayments','totalRefundPayments'],
              data:[]
          }),
          itemSelector: 'div.thumb-wrap1',
          tpl:  new Ext.XTemplate( 
        		'<tpl for=".">',
        		'<div class="thumb-wrap1">', 
        		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
    			'<tr>', 
    			'<td style="width:40%;vertical-align:top;">', 
    				'<table class="no-spacing" cellspacing="0" cellpadding="7" border="0" style="width:100%">',
    					'<tr>',
    						'<td>',
	        					    '<tr>', 
		        						'<td> <span style="font-weight:bold; color:black;">' + getProgramandcourseTranslation('TOTAL_OUTSTANDING_PAYMENT') + '</span></td>',
		        						'<td> <span style="font-weight:bold; color:blue;">'+': {totalPendingPayments} </span></td>', 
		        				    '</tr>',
		        				    '<tr>', 
		        						'<td> <span style="font-weight:bold; color:black;">' + getProgramandcourseTranslation('TOTAL_REFUND_PAYMENT') + '</span></td>',
		        						'<td> <span style="font-weight:bold; color:blue;">'+': {totalRefundPayments} </span></td>', 
	        				    '</tr>',
    						'</td>',
    					'</tr>',
    				'</table>', 
    			'</td>', 
    			'</div>',
	    '</tpl>')
    }]
    
});