/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.course.NoOfCourseAcademyLocationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.noofcourseacademylocationgrid',
	border: true,
	autoScroll: true,
	store : 'course.academyLocation.MappedCourseAcademyLocationStore',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.academyLocation.MappedCourseAcademyLocationStore',
			displayInfo : true
		} ]
	}],
	columns : [{
		header:  getCommonTranslation('ACADEMY_LOCATIONS'),
		dataIndex: 'wsAcademyLocation',
		flex: 1,
		sortable:true,
		renderer : function(value){
			var academy = value.academy;
			var location = value.location;
			if(academy!=null){
				return academy.academyName +'-'+ location.name;
			}
		}
	}]
});
