/**
 * Rajkumar
 * 
 */
Ext.define('Academia.view.course.academylocation.AcademyLocationGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.academylocationgrid',
	store : 'course.academyLocation.AcademyLocationStore',
	border: true,
	selType:'checkboxmodel',
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selModel: {
		 //showHeaderCheckbox: false,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false,
	     //injectCheckbox:1
   },
	tbar: [{
		xtype : 'button',
		itemId : 'btnAdd',
		text:getCommonTranslation('SAVE'),
		tooltip : getCommonTranslation('ADD')
	},{
		xtype : 'button',
		//itemId : 'selectAllbtn',
		text:getCommonTranslation('SELECT_ALL'),
		tooltip : getCommonTranslation('SELECT_ALL')
		
	}],
	columns :[/*{
		header : 'ID',
		hidden:true,
		dataIndex : 'id',
		flex:.1
	},*/{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'wsAcademyLocation',
		flex:1,
		renderer : function(value){
			var academy = value.academy;
			var location = value.location;
			if(academy!=null){
				return academy.academyName +'-'+ location.name;
			}
		}
	}]

});

