/**
 * @author seshagiri.k
 * @author dharmendra.prajapati
 */	   
Ext.define('Academia.view.course.coursegroup.CourseGroupForm', {
	//extend:'Academia.view.common.CustomForm',
	extend:'Academia.view.common.IdGeneratorForm',
	customFieldEntity:CONSTANTS.COURSE_GROUP_CUSTOM_FIELD,
	alias : 'widget.courseGroupForm',			
//	title : getCommonTranslation('BASIC_DETAILS,
	autoScroll: true,
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent',
	frame: false,
	border:false,
	//plain: true,
//	cls: 'panelNoSpace',
	method: 'POST',
	standardSubmit: false,
	defaults: {
		//width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items : [{
		xtype:'fieldcontainer',
		layout:'vbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
		xtype : 'hidden',
		name : 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'textfield',
				name : 'code',
				fieldLabel: getCommonTranslation('COURSE_GROUP_CODE'),
//				translationKey:'COURSE_GROUP_CODE',
				allowBlank: false,
				maxLength: 100
			},{
				xtype: 'textfield',
				name: 'groupName',
				fieldLabel: getCommonTranslation('COURSE_GROUP_NAME'),
//				translationKey:'COURSE_GROUP_NAME',
				allowBlank: false,  // requires a non-empty value
				maxLength: 100
			},{
				xtype: 'customcombobox',
				name: 'courseGroupAffiliation',
				ItemId : 'courseGroupAffiliationItemId',
				fieldLabel: getCommonTranslation('COURSE_GROUP_AFFILIATION'),
				store:Ext.create('Academia.store.course.CourseGroupAffiliationStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				editable:false
			}]},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				itemId: 'courseGroupVariableFC',
				hidden: true,
				defaults: {
					width: 700,
					labelAlign: 'top'
				},
				items:[{
					xtype:'displayfield',
					name : 'courseGroupVariable',
					itemId : 'courseGroupVariableId',
					hidden:true,
				}]}
			]},
			{
				xtype : 'fieldcontainer',
				width : '100%',
				defaults : {
					width: 536,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'radiogroup',
					name:'whetherGroups',
					fieldLabel : getCommonTranslation('COURSE_GROUP_TYPE'),
					itemId:'radioId',
					labelAlign : 'top',
					layout: 'hbox',
					items: [{
						boxLabel  : getCommonTranslation('REGULAR_GROUP'),
						name      : 'whetherGroup',
						inputValue: 1,
						checked : true
					},{
						boxLabel  : getCommonTranslation('AUDIT_GROUP'),
						name      : 'whetherGroup',
						inputValue: 3
					},{
						boxLabel  : getCommonTranslation('SPECIALIZATION_GROUP'),
						name      : 'whetherGroup',
						inputValue: 2
					}]
				}
				]},
			{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[
		    {
			xtype : 'numberfield',
			name : 'minCourses',
			itemId:'minCourses_Id',
			fieldLabel: getCommonTranslation('MIN_COURSES'),
//			translationKey:'MIN_COURSES',
			maxValue: 100,
			minValue:0,
			value:0,
			  validator : function(val) {
        		  var maxCourseField = Ext.ComponentQuery.query('numberfield#maxCourses_Id')[0];
        		  var maxValue = maxCourseField.getValue();
        		  if (maxValue != null) {
        			  if (val <= maxValue) {
        				  maxCourseField.clearInvalid();
        				  return true;
        			  } else {
        				  return 'Min '+getCommonTranslation('LOWERCASE_COURSES')+' should be less than max '+ getCommonTranslation('LOWERCASE_COURSES');
        			  }
        		  } else {
        			  maxCourseField.clearInvalid();
        			  return true;
        		  }
        	  }
		},
		{
			xtype : 'numberfield',
			name : 'maxCourses',
			itemId:'maxCourses_Id',
			fieldLabel: getCommonTranslation('MAX_COURSES'),
//			translationKey:'MAX_COURSES',
			maxValue: 500,
			minValue:0,
			value:0,
			  validator : function(val) {
        		  var minValueField = Ext.ComponentQuery.query('numberfield#minCourses_Id')[0];
        		  var minValue = minValueField.getValue();
        		  var optionalMaxCourses = Ext.ComponentQuery.query('numberfield#optionalMaxCourses_Id')[0];
        		  var optionalMaxCoursesValue = optionalMaxCourses.getValue();
        		  var maxCourseEnrollment = Ext.ComponentQuery.query('numberfield#maxCourseEnrollment_Id')[0];
        		  var maxCourseEnrollmentValue = maxCourseEnrollment.getValue();
        		  if (minValue != null) {
        			  if(val<optionalMaxCoursesValue){
        				  return 'Max '+getCommonTranslation('LOWERCASE_COURSES')+' should be equal or greater than optional max '+getCommonTranslation('LOWERCASE_COURSES');
        				  //return false
        			  }else if(val<maxCourseEnrollmentValue){
        				  return 'Max '+getCommonTranslation('LOWERCASE_COURSES')+' should be equal or greater than max enrollment  '+getCommonTranslation('LOWERCASE_COURSES')+'';
        				 // return false
        			  }
        			  else if (val >= minValue || val >= optionalMaxCourses || val >= maxCourseEnrollment) {
        				  minValueField.clearInvalid();
        				  optionalMaxCourses.clearInvalid();
        				  optionalMaxCourses.validate();
        				  maxCourseEnrollment.clearInvalid();
        				  maxCourseEnrollment.validate();
        				  return true;
        			  } else {
        				  return 'Max '+getCommonTranslation('LOWERCASE_COURSES')+' should be greater than min  '+getCommonTranslation('LOWERCASE_COURSES')+'';
        			  }
        		  } else {
        			  minValueField.clearInvalid();
        			  return true;
        		  }
        	  }
		}
		
		]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'numberfield',
			name : 'optionalMinCourses',
			itemId:'optionalMinCourses_Id',
			fieldLabel: getCommonTranslation('OPTIONAL_MIN_COURSES'),
//			translationKey: 'OPTIONAL_MIN_COURSES',
			maxValue: 100,
			minValue:0,
			value:0,
			 validator : function(val) {
       		var maxCourseField = Ext.ComponentQuery.query('numberfield#optionalMaxCourses_Id')[0];
       		var minCourse= Ext.ComponentQuery.query('numberfield#minCourses_Id')[0];
       		var optionalMinCourse = Ext.ComponentQuery.query('numberfield#optionalMinCourses_Id')[0];
       		var minCourseValue = minCourse.getValue();
       		optionalMinCourse.setMaxValue(minCourseValue);       		
       		var maxValue = maxCourseField.getValue();
       		  if (maxValue != null) {
       			  if (val <= maxValue) {
       				  maxCourseField.clearInvalid();
       				  return true;
       			  } else {
       				return 'Optional min '+getCommonTranslation('LOWERCASE_COURSES')+' should be less than optional max '+getCommonTranslation('LOWERCASE_COURSES')+'';
       			  }
       		  } else {
       			maxCourseField.clearInvalid();
       			  return true;
       		  }
       	  }
		},
		{
			xtype : 'numberfield',
			name : 'optionalMaxCourses',
			itemId:'optionalMaxCourses_Id',
			fieldLabel: getCommonTranslation('OPTIONAL_MAX_COURSES'),
//			translationKey: 'OPTIONAL_MAX_COURSES',
			maxValue: 500,
			minValue:0,
			value:0,
			 validator : function(val) {
       		  var minValueField = Ext.ComponentQuery.query('numberfield#optionalMinCourses_Id')[0];
       		  var minValue = minValueField.getValue();
       		  var optionalMaxCourse = Ext.ComponentQuery.query('numberfield#optionalMaxCourses_Id')[0];
       		  var maxValueField = Ext.ComponentQuery.query('numberfield#maxCourses_Id')[0];
       		  var maxCourseValue =  maxValueField.getValue();
       		  optionalMaxCourse.setMaxValue(maxCourseValue);       	
       		  if (minValue != null) {
       			  if (val >= minValue) {
       				  minValueField.clearInvalid();
       				  return true;
       			  } else {
       				return 'Optional max '+getCommonTranslation('LOWERCASE_COURSES')+' should be greater than optional min '+getCommonTranslation('LOWERCASE_COURSES')+'';
       			  }

       		  } else {
       			minValueField.clearInvalid();
       			  return true;
       		  }
       	  }
		}
		]	
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'numberfield',
			name : 'minCredits',
			itemId:'minCredits_Id',
			fieldLabel: getCommonTranslation('MIN_CREDITS'),
			maxValue: 2000,
			minValue:0,
			value:0,
			allowDecimals:true,
			decimalPrecision: 2,
			 validator : function(val) {
	       		  var maxCourseField = Ext.ComponentQuery.query('numberfield#maxCredits_Id')[0];
	       		  var maxValue = maxCourseField.getValue();
	       		  if (maxValue != null) {
	       			  if (val <= maxValue) {
	       				  maxCourseField.clearInvalid();
	       				  return true;
	       			  } else {
	       				  return 'Min credit should be less than max credit';
	       			  }
	       		  } else {
	       			 maxCourseField.clearInvalid();
	       			  return true;
	       		  }
	       	  }
		},{
			xtype : 'numberfield',
			name : 'maxCredits',
			itemId:'maxCredits_Id',
			fieldLabel: getCommonTranslation('MAX_CREDITS'),
			maxValue: 10000,
			minValue:0,
			value:0,
			allowDecimals:true,
			decimalPrecision: 2,
			 validator : function(val) {
	      		  var minValueField = Ext.ComponentQuery.query('numberfield#minCredits_Id')[0];
	      		  var minValue = minValueField.getValue();
	      		  if (minValue != null) {
	      			  if (val >= minValue) {
	      				  minValueField.clearInvalid();
						  minValueField.validate();
	      				  return true;
	      			  } else {
	      				return 'Max credit should be greater than min credit';	      			  }

	      		  } else {
	      			  return true;
	      		  }
	      	  }
		}
		]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'numberfield',
			name : 'minCourseEnrollment',
			itemId:'minCourseEnrollment_Id',
			fieldLabel: getCommonTranslation('MIN_COURSES_TO_ENROLL'),
//			translationKey: 'OPTIONAL_MIN_COURSES',
			maxValue: 100,
			minValue:0,
			value:0,
			 validator : function(val) {
       		var maxCourseField = Ext.ComponentQuery.query('numberfield#maxCourseEnrollment_Id')[0];
       		var minCourse= Ext.ComponentQuery.query('numberfield#minCourses_Id')[0];
       		var optionalMinCourse = Ext.ComponentQuery.query('numberfield#minCourseEnrollment_Id')[0];
       		var minCourseValue = minCourse.getValue();
       		optionalMinCourse.setMaxValue(minCourseValue);       		
       		
       		var maxValue = maxCourseField.getValue();
       		  if (maxValue != null) {
       			  if (val <= maxValue) {
       				  maxCourseField.clearInvalid();
       				  return true;
       			  } else {
       				return ' Min enrollment '+getCommonTranslation('LOWERCASE_COURSES')+' should be less than  max enrollment '+getCommonTranslation('LOWERCASE_COURSES')+'';
       			  }
       		  } else {
       			  maxCourseField.clearInvalid();
       			  return true;
       		  }
       	  }
		},
		{
			xtype : 'numberfield',
			name : 'maxCourseEnrollment',
			itemId:'maxCourseEnrollment_Id',
			fieldLabel: getCommonTranslation('MAX_COURSES_TO_ENROLL'),
//			translationKey: 'OPTIONAL_MAX_COURSES',
			maxValue: 500,
			minValue:0,
			value:0,
			 validator : function(val) {
       		  var minValueField = Ext.ComponentQuery.query('numberfield#minCourseEnrollment_Id')[0];
       		  var minValue = minValueField.getValue();
       		  var optionalMaxCourse = Ext.ComponentQuery.query('numberfield#maxCourseEnrollment_Id')[0];
       		  var maxValueField = Ext.ComponentQuery.query('numberfield#maxCourses_Id')[0];
       		  var maxCourseValue =  maxValueField.getValue();
       		  optionalMaxCourse.setMaxValue(maxCourseValue);       	
       		  if (minValue != null) {
       			  if (val >= minValue) {
       				  minValueField.clearInvalid();
       				  return true;
       			  } else {
       				return 'max enrollment '+getCommonTranslation('LOWERCASE_COURSES')+' should be greater than optional min enrollment '+getCommonTranslation('LOWERCASE_COURSES')+'';
       			  }
       		  } else {
       			  minValueField.clearInvalid();
       			  return true;
       		  }
       	  }
		}
		]	
	},,{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'courseGroupDrool',
			itemId:'courseGroupDroolItemId',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
			fieldLabel:getProgramandcourseTranslation('COURSE_GROUP_DROOL'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			editable: true,
			queryMode:'local',
			typeAhead : false,
			anyMatch : true,
			listeners:{
				  afterrender: function(field){
					  field.getStore().load();
				  }
			  }
		}, {
        	xtype: 'customcombobox',
            name: 'programEndorsement',
            itemId:'programEndorsementItemId',
            fieldLabel: getCommonTranslation('PROGRAM_ENDORSEMENT'),
            store: Ext.create('Academia.store.program.ProgramEndorsementStore'),
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            allowBlank: true
        }]	
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		width:'100%',
		defaults: {
			width: 465,
			labelAlign: 'top'
		},items : [{
			xtype: 'multiselectcombofield',
			name: 'mutuallyExclusiveCourseGroup',
			itemId: 'mutuallyExclusiveCourseGroupId',
			fieldLabel : getCommonTranslation('MUTUALLY_EXCLUSIVE_COURSE_GROUP'),
			store:Ext.create('Academia.store.course.CourseGroupCourse'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'courseGroupName',
			minChars:3,
			typeAhead:true,
			triggerCls : 'ph ph-caret-down',
			matchFieldWidth:true,
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							//else
								//Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}

		}]
		},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
		    xtype:'checkbox',
		    name: 'byPassRules',
		    boxLabel: getCommonTranslation('BY_PASS_RULES'),
		    itemId:'byPassRulesId',
		    inputValue: true,
			uncheckedValue: false
		   },{
		   	xtype:'checkbox',
		    name: 'isThisRecessTerm',
		    boxLabel: getCommonTranslation('Is_This_Recess_Term'),
		    itemId:'isThisRecessTermId',
		    inputValue: true,
		    hidden: true,
			uncheckedValue: false
		   }]
	},
	{	
		xtype:'fieldcontainer',
		width:'100%',
		cls: 'form-fixed-footer',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype : 'button',				
			itemId : 'saveCourseGroupButtonId',				
			text : getCommonTranslation('SAVE'), //Submit
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			disabled:false
		},{
			xtype : 'button',
			//itemId:'btnCancelCourseGroupForm',
			itemId:'resetBtn',						
			text : getCommonTranslation('RESET'), //Cancel
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]			
});