/**
 * @author seshagiri.k
 */	   
Ext.define('Academia.view.course.coursegroup.assigncourses.AssignCoursesForm', {
	 		extend: 'Ext.window.Window',
			alias : 'widget.assignCoursesForm',	
			requires: ['Ext.ux.form.ItemSelector'],
			modal : true,
			resizable:false,
			title : getCommonTranslation('TITLE_ASSIGN_COURSES'),	
//		    translationKey:'TITLE_ASSIGN_COURSES',
			autoScroll:true,
		    frame: true,
			items : [{
				xtype: 'idgeneratorformwin',
				id: 'assigncoursesform',
			    standardSubmit: false,	
	     	    plugins : 'formlabelrequired',
	     	   defaults: {
			         labelAlign: 'top',
			         width: 256
			     },
			    items : [
			     {	
					xtype : 'hidden',
					name : 'id'
				},{
		    		xtype : 'textfield',
		    		name : 'courseCode',
		    		fieldLabel: getCommonTranslation('COURSE_GROUP_CODE'),
//				    translationKey:'COURSE_GROUP_CODE',
		    		disabled: true
		        },{	
			    	xtype: 'multiselectcombofield',
				    name: 'courseName',
				    itemId:'courseGroup_Id',
					width: 536,
				    fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				    store:'course.coursegroup.AssignSelectCourse',
				    valueField:'id',
				    displayField:'courseCodeName',
	                allowBlank: false,
	                triggerAction: 'all',
	                queryParam:'courseName',
	    			minChars:3,
	    			typeAhead:true,
	    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	    			enableKeyEvents  : 'true',
	    			hideTrigger:false,
	    			forceSelection:true,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.width = picker.up('combobox').getSize().width;
	    					},
	    					afterRender: function(combo){
	    						combo.getStore().on("load", function(store, items){
	    							if(items.length==0)
	    								Ext.select('.x-boundlist-item').elements[0].hidden = true;
	    							//else
	    								//Ext.select('.x-boundlist-item').elements[0].hidden = false;
	    				        });
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{code}' +
	    					'</div>';
	    				}
	    			}
			    },{	
			    	xtype: 'customcombobox',
				    name: 'courseGroupName',
				    itemId:'courseGroupCombo_Id',
					width: 536,
				    fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//				    translationKey:'SELECT_COURSE',
				    store:'course.coursegroup.AssignSelectCourse',
				    valueField:'id',
				    displayField:'courseCodeName',
				    hidden:true,
				    forceSelection:true,
				    typeAhead:true				    
			    },{
			    	xtype:'hidden',
			    	name:'courseId'
			    },{
			    	xtype:'hidden',
			    	name:'whetherMandatoryValue'
			    },
		        {
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                layout: {
	                    type: 'hbox'
	                },
	                defaults: {
	                    labelAlign: 'top',
	                    width: 256
	                },
	                items: [
	                	{
	    		    		xtype : 'textfield',
	    		    		name : 'courseCredits',
	    		    		fieldLabel: getCommonTranslation('COURSE_CREDIT'),
	    		    		disabled: true
	    		        },{
	    					xtype: 'textfield',
	    					fieldLabel: getProgramandcourseTranslation('COURSE_CLUSTER_ID'),
	    					name: 'courseCluster',
	    					itemId:'courseClusterId',
	    					maxLength :255,
	    					enforceMaxLength :true,
	    					allowBlank: true,
	    					hideTrigger: true,
	    					keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false
	    				}]
	            },{
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                layout: {
	                    type: 'hbox'
	                },
	                defaults: {
	                    labelAlign: 'top',
	                    width: 256
	                },
	                items: [
	                	{
	    	        		xtype: 'radiogroup',
	    	        		itemId:'whetherMandatory_id',
	    	        		name:'whetherMandatoryitem',
	    	        		defaults: {
	    	           		 flex: 1
	    	           	 	},
	    	        		columns: 2,
	    	        		layout: 'hbox',
	    	        		allowBlank: false,
	    	        		fieldLabel: getCommonTranslation('COURSE_MANDATORY'),
//	    	        	    translationKey: 'COURSE_OPTIONAL',
	    	        		items:[{ boxLabel: 'Yes',name:'whetherMandatory', inputValue: true},
	    	        		       { boxLabel: 'No', name:'whetherMandatory', inputValue: false, checked:true}
	    	        		]
	    	           	 },{
		    	        		xtype: 'radiogroup',
		    	        		itemId:'whetherMajor_id',
		    	        		name:'whetherMajorId',
		    	        		defaults: {
		    	           		 flex: 1
		    	           	 	},
		    	        		columns: 2,
		    	        		layout: 'hbox',
		    	        		allowBlank: true,
		    	        		fieldLabel: getCommonTranslation('WHETHER_MAJOR'),
//		    	        	    translationKey: 'COURSE_OPTIONAL',
		    	        		items:[{ boxLabel: 'Yes',name:'whetherMajor', inputValue: true},
		    	        		       { boxLabel: 'No', name:'whetherMajor', inputValue: false,checked:true}
		    	        		]
		    	           	 }]
	            },
		        {
	           		xtype : 'radiogroup',
				//	width: 536,
	                fieldLabel: getCommonTranslation('ENROLLMENT_CRITERIA'),
	                name: 'enrollmentCriteriaId',
	             // layout: 'vbox',
	                layout : {
		        		 type : 'vbox'
		        	 },
		        	 defaults: {
		        	 width: 256,
	    		     labelAlign: 'top'
		        	 },
	                items : [{
	                    boxLabel : getCourseTxCommonTranslation('FIRST_COME_SERVE'),
	                    name : 'enrollmentCriteria',
	                    inputValue : 'FIRST_COME',
					//	cls : 'assignCourseRadioCls',
	                    checked:true
	                    
	                },{
	                    boxLabel : getCourseTxCommonTranslation('FACULTY_APPROVED'),
	                    name : 'enrollmentCriteria',
					//	cls : 'assignCourseRadioCls',
	                    inputValue : 'BY_FACULTY'
	                }]
	           	 },
	           	 {
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
						xtype : 'button',				
						itemId : 'saveAssignCoursesButtonId',				
						text : getCommonTranslation('SAVE'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind:true
					},{
						xtype : 'button',
						itemId:'btnCancelAssignCoursesForm',						
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
				}]
			}]			
		});