/*
 * CourseSpecializationFormWindow view for the Academies tab.
 */
Ext.define('Academia.view.course.coursespecialization.CourseSpecializationFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.coursespecializationformwindow',
    requires: [ 'Ext.form.Panel','Ext.ux.form.ItemSelector'],
	title: getCommonTranslation('COURSE_SPECIALIZATION_DETAILS'),//Academy Details
   // autoScroll: true,
    maxHeight: 600,
    modal: true,

    items: [{
        xtype: 'dynamicfieldformwin',
        defaults: {
        	labelAlign:'top',
        	width: 256
          },
        plugins : "formlabelrequired",
        items: [ {
            xtype : 'hidden',
            itemId:'courseSpecializationId',
            name : 'id'
      },{
      	xtype: 'fieldcontainer',
      	width:'100%',
      	layout: {
      		type: 'hbox'
      	},
      	defaults :{
      		width: 256,
      		labelAlign:'top'
      	},
      	items: [{
          xtype: 'textfield',
          name: 'specializationCode',
          fieldLabel: getCommonTranslation('SPECIALIZATION_CODE'),
          maxLength: 255,
          vtype:'spaceAndSpecialCharactersAsInput',
          itemId:'specializationCodeId',
          allowBlank: false
      }, {
          xtype: 'textfield',
          name: 'specializationName',
          allowBlank: false,
          vtype:'spaceAndSpecialCharactersAsInput',
          itemId:'specializationNameId',
          fieldLabel: getCommonTranslation('SPECIALIZATION_NAME'),
          maxLength: 100
      }]},{
        	xtype: 'fieldcontainer',
          	width:'100%',
          	layout: {
          		type: 'hbox'
          	},
          	defaults :{
          		width: 256,
          		labelAlign:'top'
          	},
          	items: [
          		{
                    xtype: 'textfield',
                    name: 'specializationDescription',
                    allowBlank: false,
                    itemId:'specializationDescriptionId',
                    fieldLabel: getCommonTranslation('SPECIALIZATION_DESCRIPTION')
                }, {
                    xtype: 'textfield',
                    name: 'specializationNameOtherLanguage',
                    allowBlank: true,
                    itemId:'specializationNameOtherLanguageId',
                    vtype:'spaceAndSpecialCharactersAsInput',
                    fieldLabel: getCommonTranslation('SPECIALIZATION_NAME_OTHER_LANGUAGE'),
                    maxLength: 100
                }
          	]},{
    	  xtype: 'multiselectcombofield',
          name: 'courseGroup',
          width: 536,
          itemId:'courseGroupId',
          store : 'course.coursespecialization.CourseSpecializationGroupStore',
          displayField: 'value',
          valueField: 'id',
          fieldLabel: getCommonTranslation('ASSIGN_COURSE_GROUP'),
          allowBlank: false,
          autoloadStore: false,
          queryMode:'local',
	      typeAhead : false,
		  anyMatch : true,
      		listeners:{
				  afterrender: function(field){
					  field.getStore().load();
				  }
			  }
			/*xtype: 'multiselectcombofield',
			name: 'courseReadingTopics',
			itemId:'multiTopics_Id',
			width: 536,
			fieldLabel: getCourseTxCommonTranslation('TOPICS'),
			store:'coursetransaction.coursereading.MaterialType',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			//delimiter: null,
			hidden:true*/
			
		},
		{
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
	            xtype: 'checkboxfield',
	            width: 'auto',
	            labelAlign: 'right',
	            itemId:'autoApproveSpecialization',
	            boxLabel: getProgramandcourseTranslation('AUTO_APPROVE_SPECIALIZATION'),
	            name: 'autoApproveSpecialization',
	            inputValue : true,
	            uncheckedValue: false ,
	            
	        
            	
            }]
        },
		{
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                action: 'Save',
                text: getCommonTranslation('SAVE'),
                itemId: 'CSForm_SaveButtonId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true		
            },{
                xtype: 'button',
                itemId: 'CSForm_CancelButtonId',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                hidden:true,
                itemId: 'btnViewHistory',
                text: getCommonTranslation('VIEW_HISTORY'),
                ui: 'CustomBtnThird',
                scale: CONSTANTS.BUTTONSIZE
                
            }]
        }]
    }]

});