/**
 * Sumit.meena
 */
Ext.define('Academia.view.course.readingmaterial.ReadingMaterialForm',{
	extend: 'Academia.view.common.CustomFieldForm',
	alias : 'widget.readingmaterialform',
	customFieldEntity:CONSTANTS.READING_MATERIAL_CF_DATA,
	autoScroll: true,
	layout:'anchor',
	cls:' panelNoSpace horizontalScrollingFixed x-form-fixed-footer-parent',
	frame: true,
	border:false,
	modal: true,
	method: 'POST',
	standardSubmit : false,
	title : getCourseTxCommonTranslation('READING_MATERIAL_INFORMATION'),
	plugins : "formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
		width: 256
	},
	items : [{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'hidden',
			name: 'readingId',
			itemId: 'readingId'
		},{
			xtype: 'hidden',
			name: 'inventoryTypeId',
			itemId: 'inventoryTypeId'
		},{
			xtype: 'customcombobox',
			name: 'readingType',
			itemId: 'readingTypeItemId',
			fieldLabel: getCourseTxCommonTranslation('READING_TYPE'),
			store: 'course.readingmaterial.ReadingTypeStore',
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
			allowBlank: false,
			editable : false
		},{
			xtype: 'textfield',
			name: 'readingName',
			fieldLabel: getCourseTxCommonTranslation('READING_NAME'),
			allowBlank: false,
			width: 536
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'invtPublisherMasterId',
			store:'course.readingmaterial.PublisherStore',
			fieldLabel:getCourseTxCommonTranslation('PUBLISHER'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: false, 
			typeAhead: false,
			forceSelection:true,
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name: 'firstAuthorName',
			fieldLabel: getCourseTxCommonTranslation('FIRST_AUTHOR_NAME'),
			allowBlank: false,
			width: 536	
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			name: 'secondAuthorName',
			fieldLabel: getCourseTxCommonTranslation('SECOND_AUTHOR_NAME'),
		},{
			xtype: 'textfield',
			name: 'thirdAuthorName',
			fieldLabel: getCourseTxCommonTranslation('THIRD_AUTHOR_NAME'),
		},{
			xtype: 'textfield',
			name: 'fourthAuthorName',
			fieldLabel: getCourseTxCommonTranslation('FOURTH_AUTHOR_NAME'),
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [ {
			xtype: 'textfield',
			name: 'fifthAuthorName',
			fieldLabel: getCourseTxCommonTranslation('FIFTH_AUTHOR_NAME'),
		}, {
			xtype: 'customcombobox',
			name: 'courseResourceBinding',
			itemId: 'courseResourceBinding',
			fieldLabel: getCourseTxCommonTranslation('BINDING'),
			store: Ext.create('Academia.store.course.readingmaterial.CourseResourceBindingStore'),
			valueField: 'id',
			displayField: 'Dvalue',
			typeAhead: true,
			forceSelection: true,
			editable : false
		},{
			xtype : 'numberfield',
			name : 'issuedYear',
			itemId:'issuedYear',
			fieldLabel : getProgramandcourseTranslation('PC_ISSUE_YEAR'),
			minValue:0,
			maxLength: 5,
			allowExponential :false,
			allowDecimals: false,
			hideTrigger:true,
			mouseWheelEnabled:false
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			name: 'edition',
			fieldLabel: getCourseTxCommonTranslation('EDITION')
		},{
			xtype: 'textfield',
			name: 'volume',
			fieldLabel: getCourseTxCommonTranslation('VOLUME')
		}]
	},
	{
		xtype:'fieldset',
		title: getProgramandcourseTranslation('ISBN_DETAILS'),
		width: '100%',
		style: {
			margin:'35px 0px -8px -10px !important',
		},
		itemId : 'isbnDetailsItemId',
		items: [{
			itemId : 'lblOneContactDetail',
			name:'isbnDetailMsg',
        	html: '<i>'+getProgramandcourseTranslation('PLEASE_ENTER_ATLEAST_ONE_OF_THE_FOLLOWING_ISBN_DETAILS')+'</i>'+'<span class="required" style="color:red"> *</span>',
        	margin: 0
        },{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textfield',
				name: 'isbn10',
				itemId:'isbn10ItemId',
				fieldLabel: getProgramandcourseTranslation('PC_ISBN_10'),
				maxLength:10
			},{
				xtype: 'textfield',
				name: 'isbn13',
				itemId:'isbn13ItemId',
				fieldLabel: getProgramandcourseTranslation('PC_ISBN_13'),
				maxLength:13
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textarea',
			name: 'remark',
			fieldLabel: getExaminationTranslation('REMARK'),
			width:462,
			style: {
				marginTop: '24px !important;'
			}
		}]
	},{

    	xtype: 'fieldcontainer',
    	width: '100%',
    	cls: 'form-fixed-footer',
		layout : {
			type : 'hbox'
		},
    	items: [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
    
	}]
});