/**
 * @author sumit.meena
 */
Ext.define('Academia.view.course.readingmaterial.readingmaterialinformation.AddInformationForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.addinformationform',
    autoScroll: false,   
    modal: true,
    method: 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
    items: [{
          	xtype: 'fieldcontainer',
          	layout: 'hbox',
          	defaults :{
    			width: 336,
	    		labelWidth:256,
	    		labelAlign: 'top'
    		},
          	items: [{
	          		xtype:'hidden',
	          		name:'id'
	          	},{
              		xtype:'displayfield',
              		name:'displayReadingType',
              		fieldLabel: getProgramandcourseTranslation('PC_COURSE_RESOURCE_TYPE')
              	},{
              		xtype:'displayfield',
              		name:'displayReadingName',
              		fieldLabel: getCourseTxCommonTranslation('READING_NAME')
              	},{
              		xtype:'displayfield',
              		name:'readingAuthor',
              		fieldLabel: getProgramandcourseTranslation('PC_FIRST_AUTHOR')
              	},{
              		xtype:'displayfield',
              		name:'publisher',
              		fieldLabel: getCourseTxCommonTranslation('PUBLISHER')
              	}]
          },{
        	xtype: 'fieldcontainer',
          	layout: 'hbox',
          	defaults :{
    			width: 336,
	    		labelWidth:256,
	    		labelAlign: 'top'
    		},
          	items: [{
              		xtype:'displayfield',
              		name:'isbnTen',
              		fieldLabel: getProgramandcourseTranslation('PC_ISBN_10')
              	},{
              		xtype:'displayfield',
              		name:'isbnThirteen',
              		fieldLabel: getProgramandcourseTranslation('PC_ISBN_13')
              	},{
              		xtype:'displayfield',
              		name:'issueYear',
              		fieldLabel: getProgramandcourseTranslation('PC_ISSUE_YEAR')
              	},{
              		xtype:'displayfield',
              		name:'currentStock',
              		fieldLabel: getCourseTxCommonTranslation('CURRENT_STOCK')
              	}]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
        	items: [{
            		xtype: 'customcombobox',
            		name: 'academyLocationId',
            		fieldLabel: getCourseTxCommonTranslation('ACADEMY_LOCATION'),
//            		translationKey: 'ACADEMY_LOCATION',
            		store: 'user.UserAcademyLocationStore',
            		displayField: 'value',
            		valueField: 'id',
            		forceSelection:true,
            		allowBlank: false,
            		typeAhead: true,
            		minChars:3,
            		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            		queryParam:'qry',
           			listConfig: {
           				listeners: {
           					beforeshow: function(picker) {
           						picker.minWidth = picker.up('combobox').getSize().width;
           					}
           				},
           				loadingText: getCommonTranslation('SEARCHING'),
           				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
           				getInnerTpl: function() {
           					return '<div class="search-item">' +
           					'{value}' +
           					'</div>';
           				}
           			}
            	},{
            		xtype: 'numberfield',
	                name: 'quantity',
	                fieldLabel: getCourseTxCommonTranslation('QUANTITY'),
		  			minValue: 1,
		  			maxValue:5000,
		  	        hideTrigger: true,
		  	        keyNavEnabled: false,
		  	        allowBlank: false,
		  	        allowDecimals:false,
		  	        allowExponential:false,
		  	        mouseWheelEnabled: false
            	},{
            		xtype:'textfield',
            		name:'vendorName',
            		allowBlank: false,
            		fieldLabel: getCourseTxCommonTranslation('VENDOR_NAME')
            	}]
            },{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		width: 256,
            		labelAlign: 'top'
            	},
            	items: [{
                		xtype: 'datefield',
                		name: 'purchaseDate',
                		maxValue:  Ext.Date.add(new Date(), Ext.Date.DAY, 0),
                		allowBlank: false,
                		editable : false,
                		//--submitFormat: CONSTANTS.DISPLAY_DATE_FORMAT,
                		fieldLabel: getCourseTxCommonTranslation('PURCHASE_DATE'),
        				listeners: {
        					render: function(field) {
        						return dateFormatRender(field);
        					}
        				}
                	},{
                		xtype: 'customcombobox',
                		name: 'invtItemCondition',
                		fieldLabel: getCourseTxCommonTranslation('READING_MATERIAL_CONDITION'),
                		store:'course.readingmaterial.ReadingMaterialDetailsConditionStore', 
                		allowBlank: false,
                		editable : false,
                		displayField: 'value',
                		valueField: 'id',
                		queryMode :'local'
                	}]
          },{
        	  xtype: 'fieldcontainer',
              width: '100%',
              layout: {
                  type: 'hbox'
              },
              defaults: {
                  labelAlign: 'top'
              },
              items: [{
	            	xtype: 'textarea',
	  				name: 'remark',
	  				fieldLabel: getExaminationTranslation('REMARK'),
	  				width:462
                }]
         },
         
         
         {
				xtype:'displayfield',
				value:'<b class="menu-title">'+getCourseTxCommonTranslation('UPLOAD_DOC')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{
				xtype:'fieldcontainer',
				hidden:true,
				layout:'hbox',
				//width:'100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'filefield',
					border:false,
					name: 'invtMasterDetailLinks',
					allowBlank: true,						        
					buttonText: getCommonTranslation('UPLOAD_DOC')
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype:'invtitemmasterdetaildocument',
					style:{
						marginLeft:'0px'
					}
				}]
			},
         {
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			},{
				xtype: 'button',
				name: 'invtMasterDetailDocumentId',
				text:getCommonTranslation('UPLOAD_DOC'),
				itemId: 'invtMasterDetailDocumentId',
				ui: 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE
			}]	
	  }]
});
