/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.course.readingmaterial.readingmaterialinformation.MapCoursesPncGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.mapcoursespncgrid',
    store: Ext.create('Academia.store.course.readingmaterial.PncMapCoursesStore'),
    title: getCourseTxCommonTranslation('COURSE_READING'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
        emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		itemId: 'fldContSaveItemId',
		hidden:true,
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveMapCourseItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
			//formBind : true
		}]
	}],
    columns: [{
        header: getCommonTranslation('COURSE_CODE_NAME'),
        dataIndex: 'courseId',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	itemId: 'courseId',
        	name: 'COURSE', 
        	store:Ext.create('Academia.store.course.AccessibleChildCourseStore'),
        	valueField:'id',
        	displayField:'valueCode',
        	typeAhead:false,
        	forceSelection:true,
        	queryParam:'courseName',
        	//allowBlank:false,
        	minChars:3,
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	forceSelection:true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('mapcoursespncgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				//recordToBeUpdated.set('courseId','');
        				var flag = true;
        				var itms = grid.getStore().data.items;
        				itms.forEach(function(object){
        					if(object.data.courseId  == record.data.id && object.data.readingName == recordToBeUpdated.data.readingName){
        						flag = false;
        						return false;
        					}
        				});
        				if(flag){
        					if(!isNullOrEmpty(selectedRecord.data.id)){
        						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        					}else{
        						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        					}
        					//recordToBeUpdated.set('courseId',record.data.id);
        				}else{
        					this.up().reset();
        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('READING_NAME_ALREADY_SELECTED'));
        					return false;
        				}
        			},
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}'  +
        			'</div>';
        		}
        	},
        	listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('departmentId', null);
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				//var form = Ext.ComponentQuery.query('mapcoursespncform')[0];
    				//var values = form.getValues();
    				var mapcoursespncgrid = combo.up('mapcoursespncgrid');
    				var departmentId = mapcoursespncgrid.config.departmentId;
    				var academyLocationId = mapcoursespncgrid.config.academyLocationId;
    				
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('departmentId', departmentId);
    					this.getProxy().setExtraParam('academyLocationIds', academyLocationId);
    					
    				});
    				combo.getStore().load();
    			}
    		}
        },
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('courseId')) && isNullOrEmpty(record.get('courseId'))){
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
    			else{
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('courseId');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    		}
    	}
    },{
    	header: getCommonTranslation('READING_NAME_ISBN'),
    	dataIndex: 'readingName',
    	flex: 1,
    	sortable: true,
    	editor: { 
    		xtype: 'customcombobox',
    		name: 'readingName',
    		itemId:'readingNameId',
    		store:Ext.create('Academia.store.course.readingmaterial.CourseReadingNameStore'),
    		valueField: 'id',
    		displayField: 'value',
    		queryParam:'inventoryItemName',
    		minChars:3,
    		typeAhead:false,
    		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    		enableKeyEvents  : 'true',
    		hideTrigger:false,
    		forceSelection:true,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		listConfig: {
    			listeners: {
    				select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('mapcoursespncgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				//recordToBeUpdated.set('readingName','');
        				var flag = true;
        				var itms = grid.getStore().data.items;
        				itms.forEach(function(object){
        					if(object.data.readingName  == record.data.id && object.data.courseId == recordToBeUpdated.data.courseId){
        						flag = false;
        						return false;
        					}
        				});
        				if(flag){
        					if(!isNullOrEmpty(selectedRecord.data.id)){
        						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        					}else{
        						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        					}
        					//recordToBeUpdated.set('readingName',record.data.id);
        				}else{
        					this.up().reset();
        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('READING_NAME_ALREADY_SELECTED'));
        					return false;
        				}
        			},
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code}' +
    				'</div>';
    			}
    		},
    		listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('inventoryTypeId', null);
    					this.getProxy().setExtraParam('courseId', null);
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				//var form = Ext.ComponentQuery.query('mapcoursespncform')[0];
    				//var values = form.getValues();
    				
    				var grid = combo.up('mapcoursespncgrid');
    				var selectionModel = grid.getSelectionModel().getSelection();
    				var courseId = null;
    				if(selectionModel.length>0){
    					courseId = selectionModel[0].data.courseId;
    				}
    				var inventoryTypeId = grid.config.inventoryTypeId;
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('inventoryTypeId', inventoryTypeId);
    					this.getProxy().setExtraParam('courseId', courseId);
    				});
    				combo.getStore().load();
    			}
    		}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('readingName')) && isNullOrEmpty(record.get('readingName'))){
    				rec.tdCls = 'gridInputCustomStyle';
    				return getExaminationTranslation('CLICK_TO_ENTER');
    			}
    			else{
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('readingName');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    		}
    	}
    },{
        header: getServiceRequestTranslation('STATUS'),
        dataIndex: 'status',
        flex: 0.5,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'statusItemId',
            valueField: 'id',
            displayField: 'name',
            forceSelection: true,
            editable: false,
            listeners: {
                focus: function(combo, eOpt) {
                    if (combo.getRawValue() == "")
                        combo.setRawValue(getCommonTranslation("ACTIVE"));
                    else
                        combo.setRawValue(getCommonTranslation(combo.getValue()));
                },
                blur: function(combo, r) {
                    combo.setValue(combo.getValue());
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.StatusComboStore');
                    combo.bindStore(store);
                },
                change: function(combo, eOpt) {
                    combo.setRawValue(getCommonTranslation(combo.getValue()));
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.status)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                /*if (!isNullOrEmpty(val)) {
                    if (record.data.status == 'PENDING') {
                        if (val == 'COMPLETED') {
                        	
                        } else {
                            models[rowIndex].set("completionDate", '');
                        }
                    }
                } else if (!isNullOrEmpty(record.data.status)) {
                    val = record.data.status;
                    models[rowIndex].set("status", val);
                }*/
                var colorValue = '';
                if (val == 'ACTIVE') {
                	colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
                } else if (val == 'INACTIVE') {
                	colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
                    
                } 
                return colorValue;
            }
        }
    },{
		header : getCommonTranslation('PRESCRIBED_RECOMMENDED'),
		dataIndex : 'courseReadingPrescribe',
		flex: 1.1,
		sortable: true,
		editor: {
    		xtype: 'customcombobox',
    		name: 'courseReadingPrescribe',
    		itemId: 'courseReadingPrescribeId',
    		store: Ext.create('Academia.store.course.readingmaterial.PncMapCoursesPrescribedRecStore'),
    		valueField: 'id',
            displayField: 'value',
			typeAhead : true,
    		forceSelection: true,
    		editable: false,
    		/*listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();
    			}
    		}*/
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('courseReadingPrescribe')) && isNullOrEmpty(record.get('courseReadingPrescribe'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
    },/*{
        header: getCommonTranslation('DATE_REQUIRED'),
        dataIndex: 'dateRequired',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'dateRequired',
            itemId: 'dateRequiredId',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.dateRequired)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.dateRequired)) {
                    val = record.data.dateRequired;
                }
                models[rowIndex].set("dateRequired", val);
                return dateRender(val);
            }
        }
    },*/{
        header: getCommonTranslation('PHASEOUT_YEAR'),
        dataIndex: 'phaseoutYear',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'phaseoutYear',
            itemId: 'phaseoutYearId',
            maxLength: 5,
            minValue:0,
            allowDecimals: false,
            allowExponential:false,
			keyNavEnabled: false,
			hideTrigger: true,
			mouseWheelEnabled:false,
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    },{
    	header: getCourseTxCommonTranslation('DISTRIBUTOIN_MODE'),
    	dataIndex: 'distributionMode',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'distributionMode',
    		itemId: 'distributionModeId',
    		store: Ext.create('Academia.store.coursetransaction.coursereading.DistributionMode'),
    		displayField : 'value',
			valueField : 'id',
			typeAhead : true,
    		forceSelection: true,
    		editable: false
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('distributionMode')) && isNullOrEmpty(record.get('distributionMode'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow)
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
            	
            }
        }
    }]
});