/*
 * @author Akshay.Kalbhor
 */
/*
 * File for adding the group item in the Advanced search criteria.
 */
Ext.define('Academia.view.course.requisite.CoursePreRequisiteCriteriaForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.courseprerequisitecriteriaform',
    cls: 'panelNoSpace cbCustomPanel',
    paddingLeft:  '0',
    marginLeft: '0',
    padding: '1 1 1 1',
    layout: {
        type: 'hbox'
    },
    cls: 'tbarWithnoSpacing',
    ui: 'tbarWithnoSpacing',
    plugins : "formlabelrequired",
    tbar: [{
    	xtype: 'button',
    	itemId: 'andOrComponent',
    	text: 'All',
    	cls: 'CustomBodyBtnSettings',
    	enableToggle: true,
    	pressedText: getCommonTranslation('COURSE_PRE_ANY_TEXT'),
    	depressedText: getCommonTranslation('ALL'),
    	toggleHandler: function () {
    		if(this.pressed) {
    			this.setText(this.pressedText);
    			this.up('form').andOrComponentValue = 'OR'; 
    		} else {
    			this.setText(this.depressedText);
    			this.up('form').andOrComponentValue = 'AND';
    		}
    		this.up('form').changeLogicalOperandCoursePre(this.up('form').andOrComponentValue);
    	}
    }, {
    	xtype: 'label',
    	text: getCommonTranslation('PROGRAMCOURSEPREREQUISITEDEFAULTTEXTHALF'),
    	style :{
    		color:'#000'
    	}
    },
    '->',
    {
    	xtype: 'button',
    	itemId: 'lineButtonPre',
    	cls: 'CustomBodyBtnSettings',
    	text: getCommonTranslation('ADDBUTTONTEXT'),
    	tooltip: getCommonTranslation('ADD'),
    	style: {
    		'margin-right': '4px !important;'
    	}
    }, {
    	xtype: 'button',
    	itemId: 'groupButtonPreReq',
    	cls: 'CustomBodyBtnSettings',
    	text: getCommonTranslation('GROUPBUTTONTEXT'),
    	tooltip: getCommonTranslation('COURSEPREGROUPBUTTONTOOLTIP')
    }],
    items: [{
    	xtype: 'text',
    	itemId: 'andOrComponentText',
    	minWidth: '27px',
    	padding: '9 0 0 0'
    },{
    	xtype: 'form',
    	autoScroll: true,
    	itemId: 'verticalPanel',
    	cls: 'noBorderPane',
    	margin: '0 0 0 0',
    	padding: '0 0 0 0',
    	flex: 1,
    	layout: {
    		type: 'vbox',
    		align: 'stretch'
    	}
    }],
    
    changeLogicalOperandCoursePre: function(andOrComponentText) {
    	var $this = this;
    	var searchCriteriaItemContainer = this.down('panel#verticalPanel');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;
    	var coursePreChild = this.up().down("#coursePreChildGroupItemId");
    	
    	Ext.each(searchCriteriaItems, function(childItem) {
    		$this.changeLogicalComponentTextCoursePre(andOrComponentText,childItem);
    	});
    	
    	if(!isNullOrEmpty(coursePreChild)){
    		if(coursePreChild.items.length>0){
    			Ext.each(coursePreChild.items.items, function(childItem) {
    	    		$this.changeLogicalComponentTextCoursePre(andOrComponentText,childItem);
    	    	});
    		}
    	}
    },
    
    changeLogicalComponentTextCoursePre: function(logicalOperandText,childItem) {
    	this.andOrComponentValue=logicalOperandText;
    	childItem.down('#andOrComponentText').setText(logicalOperandText);
    }
    
});