/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.coursesessiondiary.CourseSessionDiaryFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.coursesessiondiaryfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items :[{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYearId',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width: 256,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//			translationKey: 'PROGRAM',
			name:'PROGRAM',
			itemId: 'programId',
			store:'common.AssignedProgramStore',
			displayField:'code',
			valueField: 'id',
			typeAhead:false,
			forceSelection:true,
			queryParam:'name',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			name:'BATCH',
			itemId: 'batchId',
			store:'common.CurrentBatchStore',
			displayField: 'value',
			valueField: 'id',
			typeAhead:true,
			disabled:true,
			forceSelection:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			name:'PERIOD',
			itemId: 'periodId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField: 'value',
			valueField: 'id',
			typeAhead:true,
			disabled:true,
			forceSelection:true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
//			translationKey: 'COURSE',
			name : 'courseId',
			itemId : 'courseId',
			store : 'attendance.AssignedCoursesFacultyStore',
//			store : 'course.AssignedPeriodCoursesFacultyStore',
			displayField : 'courseCodeName',
			valueField : 'courseId',
			typeAhead : true,
			disable:true,
			forceSelection : true,
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{courseCodeName}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel:getExaminationTranslation('SECTION'),
			name: 'sectionId',
			itemId: 'sectionId',
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField:'sectionCode',
			valueField:'sectionId',
			typeAhead:true,
			forceSelection:true,
			disabled:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
			name : 'componentId',
			itemId : 'componentId',
			store:'course.coursecomponent.CourseComponentCouseWise',
			displayField:'componentTypeName',
			valueField : 'id',
			typeAhead : true,
			disable:true,
			forceSelection : true,
			hidden:true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			name : 'courseSectionId',
			itemId : 'CourseSection_ID',
			store:'attendance.SectionByCourseNComponent',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			forceSelection : true,
			allowBlank:true,
			hidden:true
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout:'hbox',
		itemId:'dateContainer',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'startDate',
			itemId:'startDate',
			endDateField : 'endDate',
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'endDate',
			itemId : 'endDate',
			startDateField : 'startDate',
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'facultyIds',
			itemId: 'facultyIds',
			fieldLabel: getCourseTxCommonTranslation('FACULTY'),
			store:'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
			displayField:'value',
			valueField:'id',
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
            forceSelection:true,
            //allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                    '</div>';
                }
            }
			
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'courseReadingSearchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'courseReadingResetBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
