/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.coursesessiondiary.CourseSessionDocumentLinkWin',{
	extend: 'Ext.window.Window',
	alias : 'widget.coursesessiondocumentlinkwin',
	title: getCommonTranslation('DESCRIPTION'),
	autoScroll: true,
	frame: true,
	autoScroll:true,
	modal:true,
	height: '50%',
	width: '70%',
	items: [{
	    xtype: 'grid',
	    itemId: 'courseSessionDocumentlinkGrid',
	    border:true,
	    //selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selModel: {
			multiSelect :true,
			mode:'SIMPLE',
			checkOnly : false
		},
	    store : 'coursesessiondiary.CourseSessionDescriptionStore',
		columns : [{
			header:getCommonTranslation('DESCRIPTION'),
			dataIndex: 'description',
			flex:.1,
			sortable:false,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
				if(isNullOrEmpty(val)){
		    		return "";
		    	}
				else {
				var urlRegex =  /(https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|www\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9]+\.[^\s]{2,}|www\.[a-zA-Z0-9]+\.[^\s]{2,})/gi;
                
                  return val.replace(urlRegex,"<a href='$1' target ='_'>$1</a>"); 
				}
	    		
			}
		}]	
	}]
});