/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.coursetransaction.facultyTopicAssignment.CourseSectionFTASearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursesectionftasearch',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'customcombobox',
		name:'courseId',
		width: 536,
		itemId: 'courseId',
	    store:'coursetransaction.sectionmanagement.CoruseSectionStore',
		displayField: 'courseCodeName',
		valueField: 'id',
		fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
		allowBlank:false,
		typeAhead:true,
		forceSelection:true,
        triggerAction: 'all',
        queryParam:'qry',
        minChars:3,
        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 			listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					'{value}' +
 					'</div>';
 				}
 			}
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width:'100%',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{  
				xtype: 'customcombobox',
				name:'componentSectionId',
				itemId: 'componentSectionId',
			    store:'course.coursetopic.CourseComponentStore',
				displayField: 'value',
				valueField: 'id',
				fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				hidden: true
		    },{
		    	xtype: 'customcombobox',
				name:'courseSectionId',
				itemId: 'courseSectionId',
			    store:'coursetransaction.facultytopicassignment.CourseSectionByIDStore',
				displayField: 'value',
				valueField: 'id',
				fieldLabel:getCourseTxCommonTranslation('SECTION'),
				allowBlank:false,
				disabled:true,
				typeAhead:true,
				forceSelection:true
		  }]	
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items:[{  
				
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCourseTxCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE

		     }]	
		}]	
});