/**
 * @Dharmendra.Prajapati
 * @Deepak.Mathur
 */
Ext.define('Academia.view.coursetransaction.homework.assignmentDetails.AssignmentDetails',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.HOMEWORK_ASSIGNMENT_DETAIL_CD,
	columns: 3,
	alias : 'widget.assignmentdetails',
	autoScroll: true,
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent assignmentDetailsCls',
	frame:false,
	border:false,
	method: 'POST',
	layout: {
		type: 'vbox'
	},
	standardSubmit: false,
	plugins : "formlabelrequired",

	items : [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'sectionId'
	},{
		xtype: 'hidden',
		name: 'programPeriodNameId'
	},{
		xtype: 'hidden',
		name: 'isEditable'
	},{
		xtype: 'hidden',
		name: 'responseId'
	},{
		xtype: 'hidden',
		name: 'gridStatus'
	},{
		xtype: 'hidden',
		name: 'timeGiven',
		itemId:'timeGiven'
	},{
		xtype: 'hidden',
		name: 'serverDateTime',
		itemId:'serverDateTime'
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId: 'fieldAssignmentTypeItemId',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'radiogroup',
			itemId: 'assignmentType',
			name:'assignmentType',
			width: 536,
			labelAlign:'top',
			vertical: false,
			layout: {
				type: 'hbox'
			},
			items: [{
				boxLabel: getCommonTranslation('ASSIGNMENT'),
				name: 'typeValue',
				inputValue: 'Assignment',
				checked : true
			}, {
				boxLabel: getCommonTranslation('QUIZ'),
				name: 'typeValue',
				inputValue: 'Quiz'
			}]
		}]
	}, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		/*style: {
			'position': 'relative !important'
		},*/
		items:[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			name: 'courseId',
			itemId:'courseId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
			displayField : 'courseCodeName',
			valueField : 'courseId',
			forceSelection : true,
			queryParam:'name',
			minChars:3,
			hideTrigger:false,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			allowBlank: false,	
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{courseCodeName}'  +
					'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name: 'assignmentName',
			itemId: 'assignmentNameId',
			allowBlank: false,
			maxLength: 255,
			fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_NAME')
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCourseTxCommonTranslation('HW_DATE_OF_ASSIGNMENT'),
			allowBlank: false,
			name : 'dateGiven',
			itemId:'dateGiven',
			vtype : 'daterange',
			readOnly:true,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);
				},
				change: function(obj) {
					obj.up('assignmentdetails').down('#publishDate').reset();
					obj.up('assignmentdetails').down('#publishDate').setMinValue(false);
					obj.up('assignmentdetails').down('#publishDate').setMaxValue(false);
					obj.up('assignmentdetails').down('#publishDate').setMinValue(obj.getValue());
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		/*style: {
			'position': 'initial !important',
		},*/
		items:[{
			xtype: 'customcombobox',
			name: 'facultyId',
			itemId:'faculty_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_FACULTY'),
			store:Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
			editable: true,
			allowBlank: false,	
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			disabled: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'multiselectcombofield',
			name: 'courseVariantId',
			itemId:'courseVariant_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_COURSE_VARIANT'),
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),//'course.coursevariants.CourseVariantStore',
			valueField:'id',
			allowBlank: false,	
			autoloadStore: false,
			displayField:'courseVariantCode',
			disabled:true,
			width: 536,
		    forceSelection: true,
		    matchFieldWidth:false,
		    disabled: true,
		    height:30,
		    listConfig: {listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
					picker.width = 'auto';
					setTimeout(function(){
						picker.el.dom.style.width='auto';
						picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
					},10);
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}}
		}]
	}, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 113,
			labelAlign: 'top'
		},
		/*style: {
			'position': 'initial !important'
		},*/
		items:[{
			xtype: 'fieldset',
			width: 256,
			cls: 'customTwoFieldContainerCls',
			title: getCourseTxCommonTranslation('PUBLISH_ON') + ' <span class="required" style="color:red"> *</span>',
			layout: 'hbox',
			items: [{
				xtype : 'datefield',
				width: 115,
				allowBlank: false,
				name : 'publishDate',
				itemId:'publishDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype : 'timefield',
				name : 'publishTime',		
				itemId : 'publishTime',
				width: 118,			
				//fieldLabel:getProgramandcourseTranslation(' '),
				format:'g:i A',
				increment: 15,
				vtype: 'timerange',
				submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
				//endTimeField : 'toTime',
				width:100,
				allowBlank:false,
				/*listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}*/
			}]
		},{
			xtype: 'fieldset',
			width: 256,
			cls: 'customTwoFieldContainerCls',
			title: getCourseTxCommonTranslation('SUBMISSION_DEADLINE') + ' <span class="required" style="color:red"> *</span>',
			name : 'submissionDateFieldSet',
			itemId : 'submissionDateFieldSet',
			layout: 'hbox',
			style: 'margin-left: 10px !important;',
			items: [{
				xtype : 'datefield',
				allowBlank: false,
				width: 115,
				name : 'dateSubmitted',
				itemId:'dateSubmitted',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				xtype : 'timefield',
				name : 'submittedTime',		
				itemId : 'submittedTime',
				width: 118,
				format:'g:i A',
				increment: 15,
				vtype: 'timerange',
				width:100,
				allowBlank:false,
				submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
				/*listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}*/
			}]
		},{
			xtype: 'fieldset',
			width: 256,
			cls: 'customTwoFieldContainerCls',
			title: getCourseTxCommonTranslation('EXTENDED_DEADLINE'),
			name : 'extendedDateFieldSet',
			itemId:'extendedDateFieldSet',
			layout: 'hbox',
			style: 'margin-left: 10px !important;',
			items: [{
				xtype : 'datefield',
				width: 115,
				name : 'extendedDate',
				itemId:'extendedDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				xtype : 'timefield',
				name : 'extendedTime',		
				itemId : 'extendedTime',			
				width: 118,
				format:'g:i A',
				increment: 15,
				vtype: 'timerange',
				submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
				width:100,
				/*listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}*/
			}]
		}]
	}, {
		xtype:'fieldcontainer',
		cls: 'hwRadioFieldContainerCls',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		height: 60,
		items:[{
			xtype : 'radiogroup',
			itemId:'onlineSubmission_Id',
			name: 'hwonlineSubmission',
			labelAlign : 'top',
			allowBlank: true,
			style:{marginTop:'2px'},
			fieldLabel : getCourseTxCommonTranslation('HW_ONLINE_SUBMISSION'),
			items : [{
				boxLabel : getCourseTxCommonTranslation('YES'),
				name:'onlineRadio_ID',
				inputValue : true			
			},{
				boxLabel : getCourseTxCommonTranslation('NO'),
				name:'onlineRadio_ID',	
				inputValue : false,
				checked : true
			}]
		},{
			xtype : 'radiogroup',
			itemId:'hideIdentityOnSubmissionItemId',
			name: 'hideIdentityOnSubmission',
			labelAlign : 'top',
			allowBlank: true,
			fieldLabel : getCommonTranslation('HIDE_IDENTITY_ON_ASSESSMENT'),
			items : [{
				boxLabel : getCourseTxCommonTranslation('YES'),
				name:'hideIdentityRadio_ID',
				inputValue : true			
			},{
				boxLabel : getCourseTxCommonTranslation('NO'),
				name:'hideIdentityRadio_ID',	
				inputValue : false,
				checked : true
			}]
		},{
			xtype : 'radiogroup',
			width: 220,
			itemId:'topicType_ID',
			name:'topicTypes',
			style:{marginTop:'2px'},
			fieldLabel : getCourseTxCommonTranslation('HW_TOPIC_TYPE'),
			layout: 'hbox',
			defaults: {
				flex: 1
			},
			items :[]
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		/*style: {
			'position': 'relative !important'
		},*/
		items:[{
			xtype: 'multiselectcombofield',
			name: 'courseTopicId',
			itemId: 'hw_topicsAvailabilty_id',
			fieldLabel:getCourseTxCommonTranslation('TOPIC'),
			labelAlign: 'top',
			width: 536,
			height:30,
			hidden:true,	
			autoloadStore: false,
			store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId'),
			displayField: 'value',
			valueField: 'id'
		}]		
	}
	, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		/*style: {
			'position': 'initial !important'
		},*/
		items:[{
            fieldLabel: getProgramandcourseTranslation('MAXIMUM_MARKS'), //Contact No.
            xtype: 'numberfield',
            itemId: 'maxMarks',
            name: 'maxMarks',
            minValue: 0,
            labelAlign: 'top',
            style:{marginBottom:'2px'},
            maxLength: 3,
            allowExponential :false,
			allowDecimals: false,
            mouseWheelEnabled:false,
            hideTrigger: true,

	    }]		
	}, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		/*style: {
			'position': 'initial !important'
		},*/
		items:[{
			xtype: 'checkboxfield',
			labelAlign: 'right',
			name :'isEvaluationRequired',
			itemId:'isEvaluationRequired',
			boxLabel: getCourseTxCommonTranslation('WHETHER_EVALUTION_REQUIRED'),
			style:{marginTop:'25px'},
			inputValue : true,
			uncheckedValue: false
		}]		
	}, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
/*		style: {
			'position': 'initial !important'
		},
*/		items:[{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId:'evaluationPlanId_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_EVALUATION_PLAN'),
			store:Ext.create('Academia.store.coursetransaction.homework.AssignmentAssessmentSchemeStore'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			hidden: true,
			disabled:true,
			forceSelection:true,
			editable:false
		},{
			xtype: 'multiselectcombofield',
			name: 'evaludationDetailSequenceId',
			itemId:'evaludationDetailSequenceId_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_EVALUATION_DETAIL_SEQ'),
			store:Ext.create('Academia.store.coursetransaction.homework.AssignmentAssessmentEventStore'),
			editable: true,
			valueField: 'id',
			width: 536,
			displayField: 'valueSecondValue',
			hidden: true,
			disabled:true,
			forceSelection:true,
			editable:false
		}]		
	}, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
/*		style: {
			'position': 'initial !important'
		},
*/		items:[{
			xtype: 'checkboxfield',
			name: 'configureNotification',
			itemId:'configureNotificationId',
			boxLabel: getProgramandcourseTranslation('HW_ASSIGNMENT_CONFIGURE_NOTIFICATION'),
			inputValue : true,
			uncheckedValue: false,
			disabled: true,
			hidden:true
		},{
			xtype: 'numberfield',
			name: 'noOfFile',
			itemId:'noOfFileItemId',
			fieldLabel: getCommonTranslation('NO_OF_FILES_TO_BE_UPLOADED'),
			minValue : 1,
			maxValue : 99,
			allowBlank : false,
			mouseWheelEnabled :false,
			hideTrigger :true,
			labelAlign : 'left',
			labelWidth: 175,
			value: 1,
			hidden: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId: 'fieldSendingPriorityItemId',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
/*		style: {
			'position': 'initial !important'
		},
*/		items: [{
			xtype: 'radiogroup',
			fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'),
			itemId: 'sendingPriority',
			name:'sendingPriority',
			width: 536,
			hidden: true,
			labelAlign:'top',
			vertical: false,
			layout: {
				type: 'hbox'
			},
			items: [{
				boxLabel: getMessagingModuleTranslation('IMMEDIATE'),
				itemId: 'immediate',
				name: 'sendingPriority',
				inputValue: 'IMMEDIATE'
			}, {
				boxLabel: getMessagingModuleTranslation('SCHEDULE'),
				itemId: 'schedule',
				name: 'sendingPriority',
				inputValue: 'SCHEDULE'
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		itemId: 'fieldScheduleDateItemId',
		style:{
			marginLeft: '3px',
			marginTop : '-7px',
			'position': 'initial !important'
		},
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		style: {
			'position': 'relative !important'
		},
		items: [{
			xtype: 'datefield',
			fieldLabel: getMessagingModuleTranslation('SCHEDULE_DATE'),
			name: 'msgDueDate',
			hidden: true,
			editable: false,
			itemId: 'scheduleDate',
			minValue: new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'timefield',
			name: 'msgDueDateTime',
			itemId: 'scheduleTime',
			hidden: true,
			fieldLabel: getMessagingModuleTranslation('SCHEDULE_TIME'),
			format: CONSTANTS.DISPLAY_TIME_FORMAT,                
			increment: 15,
			submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			},
			editable: false
		}]        
	},{
		xtype: 'fieldcontainer',
		plugins : "formlabelrequired",
		width:500,
		defaults: {
			labelAlign: 'top'
		},
		standardSubmit: false,
		items: [{
			xtype: 'textarea',
			name: 'shortDescription',
			itemId:'shortDescriptionItemId',
			fieldLabel: getCommonTranslation('ADD_SHORT_DESCRIPTION'),
			maxLength:1500,
			enterIsSpecial:true,
			width: 536
		}]
	}, { 	
		xtype:'fieldcontainer',
		width: 536,
		layout: 'hbox',
		margin: '0 0 16 0',
		items: [{
			xtype: 'tbspacer',
			flex: 1
		}, {
			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('GENERATE'),
			itemId: 'generateBtnAssignment',
			cls : 'CustomBtnSubmitGenerateAI',
			scale : CONSTANTS.BUTTONSIZE,
			disabled: true
		}, {
			xtype: 'button',
			text: getCommonTranslation("RESET"),
			itemId:'resetBtnAssignment',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			cls: 'btn-with-no-icon'
		}]
	}, {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
/*		style: {
			'position': 'initial !important'
		},
*/		items:[{
			xtype: 'textareafield',
			name: 'description',
			itemId:'descriptionId',
			width: 536,
			maxLength:2000,
			fieldLabel: getCourseTxCommonTranslation('HW_DESCRIPTION'),
			grow: true
		}]		
	},{
		xtype:'fieldcontainer',
		cls:'assignmentTypeCls',
		width:'100%',
		defaults: {
			labelAlign: 'top'
		},
		items:[ {
			xtype : 'radiogroup',
			itemId : 'assignmentType_Id',
			name:'assignmentType_Id',
			layout: {
				type: 'hbox'
			},
			width: 536,
			height: 65,
			fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_TYPE'),
			items :[{ 
				boxLabel:getCourseTxCommonTranslation('HW_ALL'),
				name: 'assignmentType', 
				inputValue: 'all'
			},{ 
				boxLabel:getCourseTxCommonTranslation('HW_GROUP'),
				name: 'assignmentType', 
				inputValue:'group' 
			},{ 
				boxLabel:getCourseTxCommonTranslation('HW_INDIVIDUAL'),
				name: 'assignmentType', 
				inputValue: 'individual',
			}]
		}]	
	},{
		xtype: 'assigndetailsindividualgrid',
		width:'100%',
		itemId:'individualGrid_Id',
		hidden:true,
		style:{
			marginLeft:'0px'
		}
	},{
		xtype: 'assigndetailsgroupgrid',
		width:'100%',
		itemId:'groupGrid_Id',
		hidden:true,
		style:{
			marginLeft:'0px'
		}
	},{
		xtype: 'assigndetailsallgrid',
		width:'100%',
		itemId:'assignAllGrid_Id',
		style:{
			marginLeft:'0px'
		}
	},{

		xtype:'fieldcontainer',
		width:'100%',
		cls: 'form-fixed-footer',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'hwAssignment_Add',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind:true
		}, {
			xtype : 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'hwAssignment_Cancel',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	
	}]
});
