/**
 * Abhishek Bais
 */
Ext.define('Academia.view.coursetransaction.homework.evaluationdetails.EditEvaluationDetailStructure' ,{
	extend: 'Ext.panel.Panel',
	alias: 'widget.editevaluationdetailstructure',
	//modal:true,
	autoScroll:false,
	frame:false,
	border:false,
	items: [{
		xtype:'form',
		itemId:'markDetailFormEvaluationRequired',
		cls: 'customSearchPanel',
		hidden:true,
		items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'course',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE')+'</b>'
			},{
				xtype:'displayfield',
				name:'courseVariant',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE_VARIANT')+'</b>'
			},{
				xtype:'displayfield',
				name:'section',
				fieldLabel:'<b>'+getExaminationTranslation('SECTION')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'evalPlanNo',
				fieldLabel:'<b>'+getExaminationTranslation('EVALUATION_PLAN')+'</b>'
			},{
				xtype:'displayfield',
				name:'detailSequence',
				fieldLabel:'<b>'+getExaminationTranslation('DETAIL_SEQUENCE')+'</b>'
			},{
				xtype:'displayfield',
				name:'weightage',
				fieldLabel:'<b>'+getExaminationTranslation('WEIGHTAGE')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'minPassMarks',
				fieldLabel:'<b>'+getExaminationTranslation('MIN_PASSING_MARKS')+'</b>'
			},{
				xtype:'displayfield',
				name:'maxMarks',
				itemId: 'maxMarksDisplayFieldOnEditItemId',
				fieldLabel:'<b>'+getExaminationTranslation('MAXIMUM_PASSING_MARKS')+'</b>'
			},{
				xtype:'displayfield',
				name:'effectiveWeightage',
				fieldLabel:'<b>'+getExaminationTranslation('EFFECTIVE_WEIGHTAGE')+'</b>'
			},{
				xtype:'hidden',
				name:'marksOrGrade',
				itemId: 'marksOrGrade',
			}]
		}]
	},{
		xtype: 'form',
		autoScroll: false,
		frame: false,
		hidden:true,
		itemId:'gradeDetailFormEvaluationRequired',
		cls: 'customSearchPanel',
		defaults : {
			labelAlign:'top',

		},
		style: {
			marginBottom: '5px!important',
			//background: '#ae0000'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 462
			},
			items: [{
				xtype:'displayfield',
				itemId:'displayfieldprogramCodeAndNameId',
				name: 'programCode',
				fieldLabel: getCommonTranslation('COURSE')
			},
			{
				xtype:'displayfield',
				itemId:'displayfieldProgramGroupId',
				fieldLabel: getCommonTranslation('COURSE_VARIANT')
			}]

		}]
	},{
		xtype: 'grid',
		itemId:'isEvaluationNoMarkTypeMarkEntryGridItemId',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		hidden: true,
		store:'coursetransaction.homework.AssessmentEventResultStore',
		selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		selModel: {
			checkOnly : true,
			allowDeselect: false
		},
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('SET_DEFAULT_MARKS'),
					itemId: 'evaluationNoMarkBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					cls: 'btn-with-no-icon'
				},{
					xtype: 'button',
					itemId: 'evaluationNoMarkEnterRemarkBtn',
					ui: 'CustomBtnCancel',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getExaminationTranslation('ENTER_REMARK'),
					text:getExaminationTranslation('ENTER_REMARK'),
					cls: 'btn-with-no-icon'
				},{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					itemId: 'evaluationNoSaveMarkBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					disabled: true,
					cls: 'btn-with-no-icon'
				},{
			        	xtype: 'button',
			        	text: getExaminationTranslation('RESET'),
			        	itemId: 'evaluationNoMarkGridResetBtn',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true,
						cls: 'btn-with-no-icon'
			        }
			        ]
		}],
		columns: [{
	        header: getCourseTxCommonTranslation('HW_GROUP_NAME'),
	        dataIndex: 'groupName',
	        flex:1,
	        sortable:true,
	        hidden:true
	    },{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentCode',
			 flex:1,
			sortable:true
		},{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			 flex:1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				}
			}
		},{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			 flex:1,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
	    	header: getCourseTxCommonTranslation('HW_EVALUATION_MARK_GRADE'),
	        dataIndex: 'markObtained',
	        flex:1,
	        sortable:true,
	        /*editor: {
				xtype: 'numberfield',
				name:'markObtained',
				itemId:'markObtainedItemId',
			},*/
			getEditor: function(record){
				var editEvTab = this.up('#editevaluationdetailstructureItemId');
				var isMarkType = editEvTab.isMarkType;
				var maxMarks = isMarkType ? editEvTab.maxMarks : 999;
				return Ext.create('Ext.grid.CellEditor', {
					field: Ext.create( 'Ext.form.field.Number', {
						name:'markObtained',
						itemId: 'markObtainedItemId',
						minValue:0,
						maxValue:maxMarks,
						decimalPrecision:4,
						mouseWheelEnabled:false,
						listeners: {
                            change: function(val, newVal, oldVal) {
                            	var maxMarksAssignment = editEvTab.maxMarks;
                                if (!isNullOrEmpty(editEvTab.maxMarks) && maxMarksAssignment < newVal) {
                                    showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation('MINIMUM_MARKS_CANNOT_BE_GREATER_THAN_MAXIMUM_MARKS'))
                                }
                            }
                        }
					})
				});
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		},{
			header: getCourseTxCommonTranslation('ASSIGNMENT_REMARKS'),
			dataIndex: 'remarks',
			flex:1,
			sortable: true,
			editor: {
				xtype: 'textfield',
				name:'remarks',
				itemId:'remarks',
				maxLength:1000,
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	e.grid.getSelectionModel().deselectAll();
	            }
	        }
		}]
	},{
		xtype: 'grid',
		itemId:'isEvaluationNoGradeTypeMarkEntryGridItemId',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		hidden: true,
		store:'coursetransaction.homework.AssessmentEventResultStore',
		selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		selModel: {
			checkOnly : true,
			allowDeselect: false
		},
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('SET_DEFAULT_GRADE'),
					itemId: 'evaluationNoGradeBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					cls: 'btn-with-no-icon'
				},{
					xtype: 'button',
					itemId: 'evaluationNoGradeEnterRemarkBtn',
					ui: 'CustomBtnCancel',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getExaminationTranslation('ENTER_REMARK'),
					text:getExaminationTranslation('ENTER_REMARK'),
					cls: 'btn-with-no-icon'
				},{
			        	xtype: 'button',
			        	text: getCommonTranslation('SAVE'),
			        	itemId: 'evaluationNoSaveGradeBtn',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled: true,
			        	cls: 'btn-with-no-icon'
			        },{
			        	xtype: 'button',
			        	text: getExaminationTranslation('RESET'),
			        	itemId: 'evaluationNoGradeGridResetBtn',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true,
			        	cls: 'btn-with-no-icon'
			        }
			        ]
		}],
		columns: [{
	        header: getCourseTxCommonTranslation('HW_GROUP_NAME'),
	        dataIndex: 'groupName',
	        flex:1,
	        sortable:true,
	        hidden:true
	    },{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentCode',
			 flex:1,
			sortable:true
		},{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			 flex:1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				}
			}
		},{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			 flex:1,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
	    	header: getCourseTxCommonTranslation('HW_EVALUATION_MARK_GRADE'),
	        dataIndex: 'markObtained',
	        flex:1,
	        sortable:true,
	        /*editor: {
				xtype: 'textfield',
				name:'markObtained',
				itemId:'markObtainedItemId',
			},*/
			getEditor: function(record){
				var editEvTab = this.up('#editevaluationdetailstructureItemId');
				if(!isNullOrEmpty(editEvTab.maxMarks)){
					var maxMarks = editEvTab.maxMarks;
					return Ext.create('Ext.grid.CellEditor', {
						field: Ext.create( 'Ext.form.field.Number', {
							name:'markObtained',
							itemId: 'markObtainedItemId',
							minValue:0,
							maxValue:maxMarks,
							decimalPrecision:4,
							mouseWheelEnabled:false,
							listeners: {
                                change: function(val, newVal, oldVal) {
                                	var maxMarksAssignment = editEvTab.maxMarks;
                                    if (!isNullOrEmpty(editEvTab.maxMarks) && maxMarksAssignment < newVal) {
                                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation('MINIMUM_MARKS_CANNOT_BE_GREATER_THAN_MAXIMUM_MARKS'))
                                    }
                                }
                            }
						})
					});
				}
				else{
					return Ext.create('Ext.grid.CellEditor', {
						field: Ext.create( 'Ext.form.field.Text', {
							name:'markObtained',
							itemId: 'markObtainedItemId'
						})
					});
				}
				
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		},{
			header: getCourseTxCommonTranslation('ASSIGNMENT_REMARKS'),
			dataIndex: 'remarks',
			flex:1,
			sortable: true,
			editor: {
				xtype: 'textfield',
				name:'remarks',
				itemId:'remarks',
				maxLength:1000,
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	e.grid.getSelectionModel().deselectAll();
	            }
	        }
		}]
	
	},{
		xtype: 'grid',
		itemId:'isEvaluationYesMarkTypeMarkEntryGridItemId',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		hidden: true,
		store:'coursetransaction.homework.AssessmentEventResultStore',
		selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		selModel: {
			checkOnly : true,
			allowDeselect: false
		},
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('SET_DEFAULT_MARKS'),
					itemId: 'evaluationYesMarkBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
				},{
					xtype: 'button',
					itemId: 'evaluationYesMarkEnterRemarkBtn',
					ui: 'CustomBtnCancel',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getExaminationTranslation('ENTER_REMARK'),
					text:getExaminationTranslation('ENTER_REMARK'),
				},{
			        	xtype: 'button',
			        	text: getCommonTranslation('SAVE'),
			        	itemId: 'evaluationYesSaveMarkBtn',
			        	ui: 'CustomBtnSubmit',
			        	scale: CONSTANTS.BUTTONSIZE
			        },{
			        	xtype: 'button',
			        	text: getExaminationTranslation('RESET'),
			        	itemId: 'evaluationYesMarkGridResetBtn',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true
			        }]
		}],
		columns: [{
	        header: getCourseTxCommonTranslation('HW_GROUP_NAME'),
	        dataIndex: 'groupName',
	        flex:1,
	        sortable:true,
	        hidden:true
	    },{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentId',
			flex:1,
			sortable:true
		},{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			flex:1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			flex:1,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
			header: getExaminationTranslation('MARKS_OBTAIN'),
			dataIndex: 'totalMarks',
			flex:1,
			sortable: true,
			editor: {
				xtype: 'numberfield',
				name:'totalMarks',
				minValue:0,
				maxValue:999,
				decimalPrecision:4,
				mouseWheelEnabled:false
			},
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)){
					var maxPassingMarksValue = Ext.ComponentQuery.query('#maxMarksDisplayFieldOnEditItemId')[0].getValue();
					if(rec.record.data.penaltyMarks==null&&rec.record.data.graceMarks==null){
						rec.record.set("finalMarks",val);
					}
					/**
					 * This condition if user put zero then all calculation will be zero.
					 */
					if(val==0){
						rec.record.set("finalMarks",val);
					}
					if(!isNullOrEmpty(val) && maxPassingMarksValue<val && !isNullOrEmpty(maxPassingMarksValue)){
						Ext.app.gridRendered = false;
						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
						rec.record.set("totalMarks","");
						return "";
					}else{
						return val;
					}
				}else{
					rec.tdCls = 'gridInputCustomStyle'; 
					rec.record.set("finalMarks","");
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},{
			header: getCourseTxCommonTranslation('ASSIGNMENT_REMARKS'),
			dataIndex: 'remarks',
			flex:1,
			sortable: true,
			editor: {
				xtype: 'textfield',
				name:'remarks',
				itemId:'remarks',
				maxLength:1000,
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	e.grid.getSelectionModel().deselectAll();
	            }
	        }
		}]
	},{
		xtype: 'grid',
		itemId:'isEvaluationYesGradeTypeMarkEntryGridItemId',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		hidden: true,
		store:'coursetransaction.homework.AssessmentEventResultStore',
		selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		selModel: {
			checkOnly : true,
			allowDeselect: false
		},
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('SET_DEFAULT_GRADE'),
					itemId: 'evaluationYesGradeBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
				},{
					xtype: 'button',
					itemId: 'evaluationYesGradeEnterRemarkBtn',
					ui: 'CustomBtnCancel',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getExaminationTranslation('ENTER_REMARK'),
					text:getExaminationTranslation('ENTER_REMARK'),
				},{
			        	xtype: 'button',
			        	text: getCommonTranslation('SAVE'),
			        	itemId: 'evaluationYesSaveGradeBtn',
			        	ui: 'CustomBtnSubmit',
			        	scale: CONSTANTS.BUTTONSIZE
			        },{
			        	xtype: 'button',
			        	text: getExaminationTranslation('RESET'),
			        	itemId: 'evaluationYesGradeGridResetBtn',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true
			        },{
			        	xtype:'textfield',
			        	emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
			        	width: 300,
			        	name:'examUniqueCodeText',
			        	itemId:'examUniqueCodeTextId',
			        	cls: 'SearchTextFieldWithSmallHeader',
			        	hidden:true,
			        	enableKeyEvents: true
			        }
			        ]
		}],
		columns: [{
	        header: getCourseTxCommonTranslation('HW_GROUP_NAME'),
	        dataIndex: 'groupName',
	        flex:1,
	        sortable:true,
	        hidden:true
	    },{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentId',
			flex:1,
			sortable:true
		},{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			flex:1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			flex:1,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
			header: getExaminationTranslation('Grade'),
			dataIndex: 'finalGrade',
			flex:1,
			sortable: true,
			editor: {
				xtype: 'customcombobox',
				name:'finalGrade',
				itemId:'finalGrade',
				store:'gradeMaster.GradeGroupMapping',
				valueField:'grade',
				displayField:'grade',
				editable:false
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_SELECT');
				}else{
					return rec.record.data.finalGrade;
				}
				return rec.record.data.finalGrade;
			}
		},{
			header: getCourseTxCommonTranslation('ASSIGNMENT_REMARKS'),
			dataIndex: 'remarks',
			flex:1,
			sortable: true,
			editor: {
				xtype: 'textfield',
				name:'remarks',
				itemId:'remarks',
				maxLength:1000,
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	e.grid.getSelectionModel().deselectAll();
	            }
	        }
		}]
	}]
});

