
var ManagePeriodEnrollGridStore = Ext.create('Academia.store.coursetransaction.manageperiodenrollment.ManagePeriodEnrollGridStore');
Ext.define('Academia.view.coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageperiodenrollmentlist',
	store : ManagePeriodEnrollGridStore,
	title: getCommonTranslation('LIST_OF_ENROLLED_STUDENT'),
	border: true,
	cls: 'ManagePeriodEnrollmentListCls',
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		    xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
			store : ManagePeriodEnrollGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        //grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
 /*listeners:{
 	beforeselect:function(selModel,record,index){
		if(!isNullOrEmpty(selModel.view.up())){
			var gridItemId = selModel.view.up().getItemId();
    			if(isNullOrEmpty(record.get('promotionEnrollmentStatus')) || record.get('promotionEnrollmentStatus') == "ENROLLED"){
    				return false;
    			}
		}
	}         
},*/
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('STUDENT_ENROLLMENT'),
		itemId: 'studentEnrollment'
	},{
		xtype: 'button',
		text: getCommonTranslation('OPTIONAL_PERIOD_ENROLLMENT'),
		itemId: 'optionalPeriodEnrollment',
		hidden:true,
		disabled:true
	},{
		xtype: 'button',
		text: getCommonTranslation('ENROLL'),
		itemId: 'enrollTo',
		buttonAlign: 'left',
		disabled:true
	},{
        xtype: 'button',
        text: getCommonTranslation('APPROVE'),
        itemId: 'approve',
        hidden:true,
        disabled:true
    },{
        xtype: 'button',
        text: getCommonTranslation('REJECT'),
        itemId: 'reject',
        hidden:true,
        disabled:true
    }, {
    	xtype: 'splitbutton',
		text: getCommonTranslation('MOREACTIONS'),
		itemId: 'managePeriodEnrollmentMoreActions',
		menu: [{
	        text: getCommonTranslation('CHANGE_PAYMENT_TERM'),
	        itemId: 'changePaymentTerm',
	        disabled: true
	    },{
	        text: getCommonTranslation('RESEND_CONFIRMATION_LETTER'),
	        itemId: 'resendConfirmationLetter',
	        disabled: true
	    }]
    }, {
		xtype:'displayfield',
		name : 'showEnrollmentMessage',
		itemId : 'showEnrollmentMessageId',
		hidden:true
	},{
		xtype: 'hidden',
		itemId: 'whetherAutoApproved',
		
	},{
		xtype: 'hidden',
		itemId: 'periodId'
	}],
	columns : [{
		header : getCourseTxCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex :'studentName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{ 
		header : getCommonTranslation('PAYMENT_GROUP'),
		dataIndex : 'paymentGroup',
		sortable: false,
		flex : 1.5,  
		editor : {
			xtype: 'customcombobox',
			itemId: 'paymentGroup',
			name: 'paymentGroup',
			width: 150,
			labelAlign: 'top',
			store:Ext.create('Academia.store.feeandpayment.FeePaymentGroup'),
			valueField: 'id',
			displayField:'value',
		    forceSelection:true,
		    listeners: {
				focus: function(combo, e, eOpts)
				{
					var grid = combo.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					if(record!=undefined)
					{
						var admissionId = record.data.admissionId;
						var periodId = record.data.periodId;
						combo.getStore().getProxy().extraParams={
							admissionId:admissionId,
							periodId:periodId
						}
						combo.getStore().load({
							callback:function(){
								if(record.data.promotionEnrollmentStatus=="Enrolled" || record.data.promotionEnrollmentStatus=="Request Received" || record.data.status=="In Progress" || record.data.promotionEnrollmentStatus=="Passed" ||
										record.data.promotionEnrollmentStatus=="ENROLLED" || record.data.promotionEnrollmentStatus=="REQUEST_RECEIVED"){
									record.set('paymentGroup',record.data.paymentGroup);
									combo.setReadOnly(true);
									combo.setValue(record.data.paymentGroup)
								}
							}
						});
					}
				},
			}
		},
		listeners: {
			render: function(combo){
				if(!isNullOrEmpty(combo)){
					combo.getEditor().getStore().getProxy().extraParams={
						admissionId:null,
						periodId:null
					}
					combo.getEditor().store.load();
				}
			}
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{ 
		header : getCommonTranslation('PAYMENT_TERM'),
		dataIndex : 'paymentTerm',
		sortable: false,
		flex : 1.5,  
		editor : {
			xtype: 'customcombobox',
			itemId: 'paymentTerm',
			name: 'paymentTerm',
			width: 150,
			labelAlign: 'top',
			store:Ext.create('Academia.store.feeandpayment.FeePaymentTermBypbscIdandPeriodId'),
			valueField: 'id',
			displayField: 'value',
		    forceSelection:true,
		    listeners: {
				focus : function(combo, e, eOpts)
				{
					var grid = combo.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					if(record!=undefined)
					{
						var pbscId = record.data.pbscId;
						var periodId = record.data.periodId;
						combo.getStore().getProxy().extraParams={
							pbscId:pbscId,
							periodId:periodId
						}
						combo.getStore().load({
							callback:function(){
								if(record.data.promotionEnrollmentStatus=="Enrolled" || record.data.promotionEnrollmentStatus=="Request Received" || record.data.status=="In Progress" || record.data.promotionEnrollmentStatus=="Passed" ||
										record.data.promotionEnrollmentStatus=="ENROLLED" || record.data.promotionEnrollmentStatus=="REQUEST_RECEIVED"){
									record.set('paymentTerm',record.data.paymentTerm);
									combo.setReadOnly(true);
									combo.setValue(record.data.paymentTerm)
								}
							}
						});
					}
				}
			}
		},
		listeners: {
			render: function(combo){
				if(!isNullOrEmpty(combo)){
					combo.getEditor().getStore().getProxy().extraParams={
						admissionId:null,
						periodId:null
					}
					combo.getEditor().store.load();
				}
			}
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header : getCommonTranslation('REQUEST_RECIEVED_DATE'),
		dataIndex : 'requestReceivedDateString',
		flex:1
	},{
		header : getCommonTranslation('REQUEST_APPROVE_DATE'),
		dataIndex : 'approvedDateString',
		flex:1
	},{
		header : getCommonTranslation('APPROVED_BY'),
		dataIndex : 'approvedBy',
		flex:1
	},{
		header : getCommonTranslation('REJECTION_DATE'),
		dataIndex : 'rejectedDateString',
		flex:1
	},{
		header : getCommonTranslation('REJECTED_BY'),
		dataIndex : 'rejectedBy',
		flex:1
	},{
		header : getCommonTranslation('REAMRK'),
		dataIndex : 'remark',
		flex:1
	},{
		header : getCommonTranslation('PERIOD_ENROLLMENT_STATUS'),
		dataIndex : 'promotionEnrollmentStatus',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value=="PENDING"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="REQUEST_RECEIVED"){
					return "<font color='#D2691E'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="ENROLLED"){
					return "<font color='green'>" +  getCommonTranslation(value)+"</font>";
				}
			} else {
				return "<font color='green'>" +getCommonTranslation("ENROLLED")+"</font>";
			}
		}
	},{
		header : getCommonTranslation('REGISTRATION_STATUS'),
		dataIndex : 'registrationStatus',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value=="Not Started"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="In Progress"){
					return "<font color='#D2691E'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="Open"){
					return "<font color='green'>" +  getCommonTranslation(value)+"</font>";
				}else if(value=="Closed"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}
			} 
		}
	}],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1
	},
	listeners: {
		beforeedit: function(editor, context) {
			if(editor.context.field == 'paymentGroup'){
				if(context.record.data.promotionEnrollmentStatus == 'ENROLLED' || context.record.data.promotionEnrollmentStatus == 'Enrolled'){
					context.grid.columns[5].getEditor().setReadOnly(true);
					
				}else{
					context.grid.columns[5].getEditor().setReadOnly(false);
					context.grid.columns[5].getEditor().enable(true);
					
				}
			}
			if(editor.context.field == 'paymentTerm'){
				if(context.record.data.promotionEnrollmentStatus == 'ENROLLED' || context.record.data.promotionEnrollmentStatus == 'Enrolled'){
					context.grid.columns[6].getEditor().setReadOnly(true);
					
				}else{
					context.grid.columns[6].getEditor().setReadOnly(false);
					context.grid.columns[6].getEditor().enable(true);
					
				}
			}
		}
	}
});
