Ext.define('Academia.view.coursetransaction.promotion.DocumentNotesViewAllWindow',{
	extend:'Ext.window.Window',
	alias:'widget.documentnotesviewallwindow',
	modal : true,
	resizable:false,
	autoScroll:true,
	title: getCommonTranslation('DOCUMENTS_AND_NOTES'),
	height: '90%',
	width: 1150,
	frame: true,	
	layout: 'vbox',
	closeAction: 'destroy',
	initComponent: function() {
        var this$ = this;
        var store = Ext.create('Academia.store.personinfo.student.StudentForAcademicToicsStore');
        Ext.apply(this$, {
        	items:[{
        		xtype: 'form',
        		plugins: "formlabelrequired",  
        		autoScroll: true,
        		cls:'customSearchPanel',
        		width: 1055,
        		items:[{
        			xtype : 'fieldcontainer',
        			width: 'auto',
        			layout : {
        				type : 'hbox'
        			},
        			defaults : {
        				width: 256,
        				labelAlign : 'top'
        			},
        			items:[{
        				xtype : 'customcombobox',
        				width: 256,
        				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
        				name : 'academicTerm',
        				itemId : 'academicTerm',
        				displayField : 'value',
        				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
        				valueField : 'id',
        				typeAhead : true,
        				editable : false
        			},{
        				xtype : 'customcombobox',
        				name : 'academicTopicId',
        				itemId:'academictopic',
        				fieldLabel : getCommonTranslation('CATEGORY'),
        				store: Ext.create('Academia.store.student.studentprofile.AcademicTopicStore'),
        				valueField: 'id',
        	            displayField: 'value',
        				typeAhead : false,
        				forceSelection:true,
        				hideTrigger:false,
        				triggerAction: 'all',
        				editable:false
        			}]
        		},{
        			xtype: 'fieldcontainer',
        			width: 'auto',
        			cls: 'customSearchPanelBtnsFieldContainerCls',
        			items: [{
        				xtype: 'button',
        				text: getCommonTranslation('SEARCH'),
        				itemId: 'searchBtn',
        				buttonAlign: 'left',
        				ui: 'CustomBtnSubmit',
        				scale: CONSTANTS.BUTTONSIZE,
        				formBind:true
        			},{
        				xtype: 'button',
        				text: getCourseTxCommonTranslation('RESET'),
        				itemId: 'resetBtn',
        				buttonAlign: 'left',
        				ui: 'CustomBtnCancel',
        				scale: CONSTANTS.BUTTONSIZE	        				
        			}]
        		}]
        	},{
        		xtype:'grid',
        		title: getCommonTranslation('DOCUMENTS_AND_NOTES'),
        		itemId: 'allDocumentsAndNotesGrid',
        		border: true,
        		width: 1060,
        		minHeight: 100, // Set the minimum height
        		maxHeight: 300, // Set the maximum height
        		viewConfig: {
        			stripeRows: true
        		},
        		store: store,
        		dockedItems: [{
                    xtype: 'toolbar',
                    dock: 'bottom',
                    items: [{
                        xtype: 'custompagingtoolbar',
                        plugins: ['pagesize'],
                        store: store,
                        emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
                        displayInfo: true
                    }]
                }],
        		columns: [{
        			header: getCommonTranslation('ACADEMIC_TERM'),
        			dataIndex: 'academicTerm',
        			flex:.2,
        			sortable: true,
        			renderer:function(value,meta,record){
        				if(value){
        					return value.value
        				}
        				else {
        					return '';  
        				}
        			}
        		},{
        			header: getCommonTranslation('CATEGORY'),
        			dataIndex: 'academicTopic',
        			sortable: false,
        			flex: .2
        		}, {
        			header: getCommonTranslation('SUB_CATEGORY'),
        			dataIndex: 'academicSubTopic',
        			sortable: false,
        			flex: .2
        		}, {
        			header: getCommonTranslation('DATE'),
        			dataIndex: 'createdAt',
        			sortable: false,
        			flex: .2,
        	        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
                        return dateRender(val);
        			}
        		},{
        			header: getCommonTranslation("URLS"),
        			dataIndex: 'academicTopicUrls',
        			flex:.2,
        			sortable: true,
        			renderer:function(value,rec){
        				if(!isNullOrEmpty(rec.record.get('urlName'))) {
        					if(rec.record.get('academicTopicUrls').length == 1) {
        						value = rec.record.get('academicTopicUrls')[0].name;
        						var value1=!isNullOrEmpty(value)?value:rec.record.get('academicTopicUrls')[0].name;
        						var newPath=rec.record.get('academicTopicUrls')[0].path;    
        						var val=!isNullOrEmpty(value1)?value1:newPath;
        						return "<a href="+newPath+" target='_blank'>"+val;
        					}
        					else {
        						var value1=!isNullOrEmpty(rec.record.get('urlName'))?rec.record.get('urlName'):rec.record.data.name;
        						var newPath=rec.record.data.path;    
        						var val=!isNullOrEmpty(value1)?value1:newPath;
        						return "<a href='javascript:void(0)'>"+val;
        					}
        				}
        				else {
        					return "";
        				}
        			}
        		},{
        			header: getCommonTranslation("DOCUMENTS"),
        			dataIndex: 'academicTopicDocuments',
        			flex:.2,
        			sortable: true,
        			renderer:function(value,rec){
        				if(!isNullOrEmpty(rec.record.get('documentName'))) {
        					var value1=!isNullOrEmpty(rec.record.get('documentName'))?rec.record.get('documentName'):rec.record.data.name;
        					var newPath=rec.record.data.path;    
        					var val=!isNullOrEmpty(value1)?value1:newPath;
        					return "<a href='javascript:void(0)'>"+val;
        				}
        				else {
        					return "";
        				}
        			}
        		}, {
        			header: getProgramandcourseTranslation('REMARKS'),
        			dataIndex: 'description',
        			sortable: false,
        			flex: .2

        		}]
        	}]
        });
        this$.callParent(arguments);
    }
});