/*
 -------------Mahendr Vishvkarma
*/

var PromotionPanelListStore = Ext.create('Academia.store.coursetransaction.promotion.PromotionPanelList');
Ext.define('Academia.view.coursetransaction.promotion.PromotionPanelList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.promotionpanellist',
	store: PromotionPanelListStore,
	title: getProgramandcourseTranslation('PROMOTION_LIST'),
	border: true,
	cls: 'promotionlistGridCls',
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false,
		allowDeselect: false
	},
	style: {
		zIndex: '1 !important'
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	isGridConfigurable: true,
	enableColumnHide: true,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
			  itemId:'custompagingtoolbar',
	          plugins:['pagesize'],
			  store : PromotionPanelListStore,
			  emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			  displayInfo : true
		} ]
	}
	],
	plugins: [
        {
      	  ptype : 'cellediting',
      	  clicksToEdit: 1
        }
        ],
	tbar: [{
		xtype : 'button',
		text:getCommonTranslation('ADD_TO_PANEL'),
    	itemId:'addToPanelBtnId',
    	disabled: true
	}, {
		xtype : 'button',
		text:getCommonTranslation('SUBMIT'),
    	itemId:'promotionSaveBtn',
    	disabled: true,
    	hidden: true
	}, {
		xtype: 'splitbutton',
		text: getCommonTranslation('MOREACTIONS'),
		itemId: 'promotionMoreActions',
		hidden: true,
		menu: [{
			text:getProgramandcourseTranslation('DETAILED_VIEW'),
			itemId:'detailedViewId',
			disabled: true
		}, {
			text:getCommonTranslation('REVERT_TO_DRAFTED'),
			itemId:'revertToDraftedBtn',
			disabled: true,
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns : [{
		header : getProgramandcourseTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',		
		flex:1,
		renderer:function(value,meta,record){
			if(isNullOrEmpty(value)){
				return value;
			} else {
				return '<a href=#>'+value+'</a>'
			}
		}
	},{
		header :getProgramandcourseTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('PROGRAM'),
//	    translationKey: 'PROGRAM_FROM',
		dataIndex : 'programName',
		flex:1
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},/*{
		header : getProgramandcourseTranslation('VIEW_DETAILS'),
		dataIndex : 'viewDetails',
		flex:1,
		renderer:function(value,meta,record){
				return '<a href=#>'+getProgramandcourseTranslation('VIEW_DETAILS')+'</a>'
		}
	}*/{
		header : getProgramandcourseTranslation('DECISION'),
		dataIndex : 'decision',
		flex:1,
		editor : {
			xtype: 'customcombobox',
			itemId: 'promotionStatusId',
			name: 'promotionStatus', 
			store: Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgressionStatusPeriodStore'),
			valueField:'value',
			displayField:'value',
			typeAhead:false,
			forceSelection:true,
			queryParam:'qry'
		}
	},
	{
		header : getProgramandcourseTranslation('TEMPLATE'),
		dataIndex : 'template',
		flex:1,
		hidden: true
	},
	{
		header : getProgramandcourseTranslation('REMARK'),
		dataIndex : 'remark',
		flex:1,
		renderer: function(val, metaData) {
			if(!isNullOrEmpty(val)){
		    var encodedValue = Ext.String.htmlEncode(val).replace(/\n/g, '<br>');
		    metaData.tdAttr = 'data-qtip="' + encodedValue + '"'; // Tooltip to show full content on hover

		    return '<div class="promotion-panel-list-remark-cell">' + encodedValue + '</div>';
			}
		},
		 editor: {
		        xtype: 'textfield',
		        allowBlank: true
		    }
	},
	{
		header : getProgramandcourseTranslation('AVERAGE'),
		dataIndex : 'averageSpa',
		flex:1
	},
	{
		header : getCommonTranslation('US_ECTS'),
		dataIndex : 'obtainedCredit',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD_STATUS'),
		dataIndex : 'periodStatus',
		flex:1,
		renderer:function(val,rec){
			if(isNullOrEmpty(val)){
				return "";
				//rec.tdCls = 'gridInputCustomStyle'; 
				//return getExaminationTranslation('CLICK_TO_SELECT');
			}else{
				if(rec.record.data.enrollmentStatus == "Suspended" || rec.record.data.enrollmentStatus.indexOf("Suspended")!=-1){
					return "Suspended";
				}else if(rec.record.data.periodStatus == 'ADD_ENROLLMENT'){
				     return getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT'); 	
				}else{
				return getCommonTranslation(rec.record.data.periodStatus);
				}
			}
		}
	},{
		header : getCommonTranslation('ENROLLMENT_STATUS'),
		dataIndex : 'enrollmentStatus',
		flex:1
	},{
		header : getCommonTranslation('PROGRESSION_STATUS'),
		dataIndex : 'progressionStatus',
		flex:1
	},
		{
			header: getProgramandcourseTranslation('PROGRESSION_PANEL_HOLD'),
			dataIndex: 'holdCount',
			flex: 1,
			renderer: function(val, rec) {
				if (isNullOrEmpty(val)) {
					return "-";
				} else {
					return "Y"
				}
			}

	}],
	plugins: [{
	    ptype: 'cellediting',
	    clicksToEdit: 1,
	    listeners: {
	        beforeedit: function(editor, e) {
	            var status = e.record.get('progressionStatus');
	            var editableFields = ['decision', 'remark'];

	            if (Ext.Array.contains(editableFields, e.field)) {
	                if (!status || !Ext.Array.contains(['drafted', 'pending'], status.toLowerCase())) {
	                    return false; // Block editing
	                }
	            }
	            return true; // Allow editing
	        }
	    }
	}]
});
