/**
 * @author Mahendr.Vishvkarma
 * 
 */
Ext.define('Academia.view.coursetransaction.promotion.PromotionPanelSearch', {   
	//extend : 'Ext.form.FormPanel',
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.promotionpanelsearch',  
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    //layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items : [{
       		 xtype : 'customcombobox',
    		 name : 'academyLocationId',
    		 itemId:'academyLocationId',
    		 fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//    		 translationKey:'ACADEMY_LOCATION',
    		 store:'attendance.attendancereport.AcadmyByAdmission',
    		 width: 256,
    		 valueField : 'id',
    		 displayField : 'value',
    		 allowBlank : false,
    		 queryMode:'local',
			 typeAhead : false,
			 forceSelection : true,
			 anyMatch : true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
    	 },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			hidden : false,
			allowBlank: false,
			queryMode:'local',
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
					combo.bindStore(store);
					store.load();
				}
			}
		},{

            itemId: 'studentId',
        	xtype: 'customcombobox',
			name: 'studentId',
			fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
			store: 'messaging.StudentsFilterByAcademyLocationIdStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        }]
    },
            {
        	xtype: 'fieldcontainer',
        	width: 'auto',
        	layout: 'hbox',
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
        	items : [{
            	xtype: 'customcombobox',
    			name: 'programGroup',
    			itemId:'ProgramGroupItemId',
    			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
//    			translationKey: 'PROGRAM_GROUP',
    			store:'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
    			editable: true,
    			valueField: 'id',
    			displayField: 'value',
    			forceSelection:true,
    			hidden:true
    			//allowBlank: false
            },{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//        	    translationKey: 'PROGRAM',
        		name : 'programId',
        		itemId : 'programId',
        		store:'common.ProgramByAcademyLocationStore',
        		displayField:'valueCode',
        		valueField:'id',
         		width: 536,
        		typeAhead:true,
        		allowBlank:true,
        		forceSelection:true,
        		triggerAction: 'all',
	            minChars:3,
	            queryParam:'programName',
	    	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	    listConfig: {
					  /*listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},*/
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
        	},{
        		xtype: 'customcombobox',
        		name: 'periodId',
        		itemId:'periodId',
        		fieldLabel: getExaminationTranslation('PERIOD'),
        		store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.PeriodsByProgramAndAcademicTerm'),
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		allowBlank:true,
        		disabled:true
        	}]
        },{
            	xtype : 'fieldcontainer',
            	width: 'auto',
            	layout: 'hbox',
            	defaults : {
            		width: 256,
            		labelAlign : 'top'
            	},
            	items : [/*{
            		xtype: 'customcombobox',
            		name: 'promotionType',
            		itemId:'promotionTypeId',
            		fieldLabel: getProgramandcourseTranslation('PROMOTION_TYPE'),
            		store:'coursetransaction.promotion.PromotionType',
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		typeAhead:true
            	},*/{
					xtype: 'customcombobox',
					name: 'periodStatus',
					itemId: 'periodStatus',
					fieldLabel: getCommonTranslation('PERIOD_STATUS'),
					store:'personinfo.common.personalinfo.PromotionPanelEnrollmentStatus',
					displayField:'value',
					valueField:'enrollmentStatus',
		            editable: false
				},{
            		xtype: 'customcombobox',
            		name: 'promotionStatus',
            		itemId:'promotionStatusId',
            		fieldLabel: getProgramandcourseTranslation('PROMOTION_STATUS'),
            		store:'program.programDetails.programBatches.programPeriod.ProgressionStatusPeriodStore',
            		displayField:'value',
            		valueField:'id',
             		width: 256,
            		forceSelection:true,
            		typeAhead:true,
            		queryMode: 'local',
            	},{xtype: 'customcombobox',
					name: 'enrollmentStatus',
					itemId: 'enrollmentStatus',
					fieldLabel: getCommonTranslation('ENROLLMENT_STATUS'),
					store:'coursetransaction.promotion.EnrollmentStatusStore',
					displayField:'value',
					valueField:'id',
		            editable: false
		            },
            	]},{
                	xtype : 'fieldcontainer',
                	width: 'auto',
                	layout: 'hbox',
                	defaults : {
                		width: 256,
                		labelAlign : 'top'
                	},
                	items : [{
                		xtype:'checkbox',
                		boxLabel: getCommonTranslation('SHOW_NON_PANEL_STUDENT'),
                		name:'nonPanelStudentCheckBox',
                		itemId:'nonPanelStudentCheckBox',
                		style: {
                			marginTop: '25px !important;'
                		},
                		inputValue:true,
                		uncheckedValue:false
                	/*	listeners:{
            				change: function(checkbox, newValue, oldValue) {
            					if(newValue)
            					{
            						var form = checkbox.up('form');
            						var progressionPanel = form.down('#progressionPanel');
            						progressionPanel.setDisabled(true);
            						form.isValid();
            					}
            					else{
            						var form = checkbox.up('form');
            						var progressionPanel = form.down('#progressionPanel');
            						progressionPanel.setDisabled(false);
            						form.isValid();
            					}
            				}
            			}*/
                	},{
    					xtype: 'customcombobox',
    					name: 'progressionPanel',
    					itemId: 'progressionPanel',
    					fieldLabel: getCommonTranslation('PROGRESSION_PANEL'),
    					store:'committee.committee.CommitteeProgressionPanelStore',
    					displayField:'value',
    					valueField:'id',
    		            editable: false,
    		            allowBlank:false
    				},{
                		xtype: 'customcombobox',
                		name: 'progressionStatus',
                		itemId:'progressionStatusId',
                		fieldLabel: getCommonTranslation('PROGRESSION_STATUS'),
                		store:'coursetransaction.promotion.ProgressionStatusStore',
                		displayField:'value',
                		valueField:'id',
                		editable: false,
                		margin: '0 0 0 10'
                	}
                	]},{
        		xtype: 'fieldcontainer',
        		width: 'auto',
        		layout : {
        			type : 'hbox'
        		},
        		cls: 'customSearchPanelBtnsFieldContainerCls',
        		items: [{
        			xtype: 'button',
        			text: getCommonTranslation('SEARCH'),
        			itemId: 'searchBtn',
        			buttonAlign: 'left',
        			ui: 'CustomBtnSubmit',
                    formBind: true,
        			scale: CONSTANTS.BUTTONSIZE
        		},{
        			xtype: 'button',
        			text: getCourseTxCommonTranslation('RESET'),
        			itemId: 'resetBtn',
        			buttonAlign: 'left',
        			ui: 'CustomBtnCancel',
        			scale: CONSTANTS.BUTTONSIZE
        		}]
        	}]
    	//}]
});