/**
 * @author Dharmendra.P
 * 
 */
Ext.define('Academia.view.coursetransaction.promotion.PromotionSearch', {   
	//extend : 'Ext.form.FormPanel',
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.promotionsearch',  
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    //layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items : [{
       		 xtype : 'customcombobox',
    		 name : 'academyLocationId',
    		 itemId:'academyLocationId',
    		 fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//    		 translationKey:'ACADEMY_LOCATION',
    		 store:'attendance.attendancereport.AcadmyByAdmission',
    		 width: 256,
    		 valueField : 'id',
    		 displayField : 'value',
    		 allowBlank : false,
    		 queryMode:'local',
			 typeAhead : false,
			 forceSelection : true,
			 anyMatch : true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
    	 },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			queryMode:'local',
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store);
					store.load();
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			hidden : false,
			queryMode:'local',
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
					combo.bindStore(store);
					store.load({
   					 callback: function(rec, success) {
   						 if (success) {
   							 for(var i in rec){
   								 if(rec[i].get('sequence')==1){
   									 combo.setValue(rec[i].get('id'));
   								 }
   							 }
   							
   						 }
   					 }
   				 });
				}
			}
		}]
    },
            {
        	xtype: 'fieldcontainer',
        	width: 'auto',
        	layout: 'hbox',
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
        	items : [{
            	xtype: 'customcombobox',
    			name: 'programGroup',
    			itemId:'ProgramGroupItemId',
    			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
//    			translationKey: 'PROGRAM_GROUP',
    			store:'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
    			editable: true,
    			valueField: 'id',
    			displayField: 'value',
    			forceSelection:true,
    			//allowBlank: false
            },{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//        	    translationKey: 'PROGRAM',
        		name : 'programId',
        		itemId : 'programId',
        		store:'common.ProgramByAcademyLocationStore',
        		displayField:'valueCode',
        		valueField:'id',
         		width: 536,
        		typeAhead:true,
        		allowBlank:true,
        		forceSelection:true,
        		triggerAction: 'all',
	            minChars:3,
	            queryParam:'programName',
	    	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	    listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
        	}]
        },{
        	xtype : 'fieldcontainer',
        	width: 'auto',
        	layout: 'hbox',
        	defaults : {
        		width: 256,
        		labelAlign : 'top'
        	},
        	items : [,{
        		xtype: 'customcombobox',
        		name: 'batchId',
        		itemId:'batchId',
        		fieldLabel : getCourseTxCommonTranslation('BATCH'),
        		disabled:false,
        		store: 'enquiry.AcademicBatchStore',
        		valueField: 'id',
        		displayField: 'value',
        		allowBlank:true,
        		queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				anyMatch: true,
        	},{
        		xtype: 'customcombobox',
        		name: 'periodId',
        		itemId:'periodId',
        		fieldLabel: getExaminationTranslation('PERIOD'),
        		store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		allowBlank:true,
        		disabled:true
        	},{
        		xtype : 'customcombobox',
        		fieldLabel : getCourseTxCommonTranslation('SECTION'),
        		name : 'sectionId',
        		itemId : 'sectionId',
        		store:'attendance.SectionAndFacultyByPeriodID',
        		displayField : 'sectionCode',
        		valueField : 'sectionId',
        		typeAhead : true,
        		disabled:true,
        		allowBlank:true,
        		forceSelection : true
        	}/*,{
        		xtype: 'customcombobox',
        		name: 'facultyName',
        		itemId: 'facultyItemId',
        		fieldLabel:getExaminationTranslation('FACULTY'),
        		valueField: 'id',
        		displayField: 'value',
        		queryParam:'codeOrName',
        		minChars:3,
        		width: 256,
        		typeAhead:false,
        		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        		hideTrigger:true,
        		enableKeyEvents  : 'true',
        		forceSelection : true,
        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		listConfig: {
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			getInnerTpl: function() {
        				return '<div class="search-item">' +
        				'{value}' +
        				'</div>';
        			},
        			listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        		},
        		listeners: {
        			render: function(combo) {
        				var store = Ext.create('Academia.store.coursetransaction.facultytopicassignment.AssignFacultyStore');
        				combo.bindStore(store);
        			}
        		}
        	}*/
        	]},{
            	xtype : 'fieldcontainer',
            	width: 'auto',
            	layout: 'hbox',
            	defaults : {
            		width: 256,
            		labelAlign : 'top'
            	},
            	items : [/*{
            		xtype: 'customcombobox',
            		name: 'promotionType',
            		itemId:'promotionTypeId',
            		fieldLabel: getProgramandcourseTranslation('PROMOTION_TYPE'),
            		store:'coursetransaction.promotion.PromotionType',
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		typeAhead:true
            	},*/{

	                itemId: 'studentId',
	            	xtype: 'customcombobox',
	    			name: 'studentId',
	    			fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
	    			store: 'messaging.StudentsFilterByAcademyLocationIdStore',
	    			valueField: 'id',
	    			displayField: 'valueCode',
	    			queryParam:'studentNameOrCode',
	    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			enableKeyEvents  : 'true',
	    			minChars:3,
	    			typeAhead:false,
	    			forceSelection:true,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			triggerAction: '',
	    			hideTrigger:false,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{studentCode} / {studentName}' +
	    					'</div>';
	    				}
	    			}
	            },{
	                xtype: 'customcombobox',
	                name: 'programCoordinator',
	                fieldLabel: getCompletionModuleTranslation('PPROGRAM_COORDINATOR'),
	                itemId: 'programCoordinatorId',
	                store: Ext.create('Academia.store.completion.completionform.ProgramCoordinatorStore'),
	                valueField: 'id',
	                displayField: 'value',
	                queryParam:'qry',
	                queryMode : 'remote',
	                minChars:3,
	                hidden:true,
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	 			listConfig: {
	    	 				listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	 				loadingText: getCommonTranslation('SEARCHING'),
	    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	 				getInnerTpl: function() {
	    	 					return '<div class="search-item">' +
	    	 					'{value}' +
	    	 					'</div>';
	    	 				}
	    	 			}
	            },{
            		xtype: 'customcombobox',
            		name: 'promotionStatus',
            		itemId:'promotionStatusId',
            		fieldLabel: getProgramandcourseTranslation('PROMOTION_STATUS'),
            		store:'coursetransaction.promotion.PromotionStatus',
            		displayField:'value',
            		valueField:'id',
             		width: 256,
            		forceSelection:true,
            		typeAhead:true,
            		queryMode: 'local',
            	},{
            		xtype:'checkbox',
            		boxLabel: getCommonTranslation('BYPASS_PERIOD_DATE'),
            		name:'byPassPeriod',
            		itemId:'byPassPeriodDateId',
            		margin: '25 0 0 0',
            		inputValue:true,
            		uncheckedValue:false,
            		hidden:true,
            	}
            	]},{
        		xtype: 'fieldcontainer',
        		width: 'auto',
        		layout : {
        			type : 'hbox'
        		},
        		cls: 'customSearchPanelBtnsFieldContainerCls',
        		items: [{
        			xtype: 'button',
        			text: getCommonTranslation('SEARCH'),
        			itemId: 'searchBtn',
        			buttonAlign: 'left',
        			ui: 'CustomBtnSubmit',
                    formBind: true,
        			scale: CONSTANTS.BUTTONSIZE
        		},{
        			xtype: 'button',
        			text: getCourseTxCommonTranslation('RESET'),
        			itemId: 'resetBtn',
        			buttonAlign: 'left',
        			ui: 'CustomBtnCancel',
        			scale: CONSTANTS.BUTTONSIZE
        		}]
        	}]
    	//}]
});