/**
 *  Dharmendra.p
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.AssignFacultyTimeTable',{
	extend: 'Ext.window.Window',
	alias: 'widget.assignfacultytimetable',
	title: getProgramandcourseTranslation('ASSIGN_FACULTY'),
	modal: true,
	maxHeight:600,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		layout: 'anchor',
		defaults: {
			labelAlign: 'top',
			width: 536,
			anchor: '100%'
		},
		standardSubmit: false,
		plugins:"formlabelrequired",
		items: [{  
			xtype: 'hidden',
			name: 'id'
		},{  
			xtype: 'hidden',
			name: 'facultyConflitCheck',
			itemId: 'facultyConflitCheck'
		},{
			xtype: 'multiselectcombofield',
			name: 'facultyId',
			itemId:'faculty_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_FACULTY'),
			store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CommonFacultyStore',
			autoloadStore: false,
			width: 536,
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			addAllSelector: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = 'auto';
						setTimeout(function(){
							picker.el.dom.style.width='auto';
							picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
						},10);
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							var allItems = combo.listKeyNav.boundList.all.elements;
							var selectedDate = '';
							var comboStore = combo.getStore();
							if(typeof combo.getValue() != "string" && combo.getValue().length<6){
								Ext.each(allItems, function(currentItem){
									currentItem.classList.remove("disabledComboItem");
								});
							}
							else if(combo.getValue().length==6){
								var valueArray = [];
								Ext.each(combo.getValue(), function(currentValue){
									if(typeof currentValue=="object"){
										valueArray.push(currentValue.get('id'));
									}
									else{
										valueArray.push(currentValue);
									}
								});
								
								Ext.each(allItems, function(currentItem){
									var currentFacultyId = currentItem.viewRecordId;
									var currentFacultyRecord = comboStore.findRecord('id',currentFacultyId);
									if(valueArray.indexOf(currentFacultyRecord.get('id'))!="-1"){
										currentItem.classList.remove("disabledComboItem")
									}
									else{
										currentItem.classList.add("disabledComboItem");
									}
								});
								
							}
						}
						catch(e){}
					}
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
						if(typeof combo.getValue()=="object" && combo.getValue().length==6){
							return false;
						}
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedDate = '';
					var comboStore = combo.getStore();
					if(typeof combo.getValue() != "string" && combo.getValue().length<6){
						Ext.each(allItems, function(currentItem){
							currentItem.classList.remove("disabledComboItem");
						});
					}
					else if(combo.getValue().length==6){
						var valueArray = [];
						Ext.each(combo.getValue(), function(currentValue){
							if(typeof currentValue=="object"){
								valueArray.push(currentValue.get('id'));
							}
							else{
								valueArray.push(currentValue);
							}
						});
						
						Ext.each(allItems, function(currentItem){
							var currentFacultyId = currentItem.viewRecordId;
							var currentFacultyRecord = comboStore.findRecord('id',currentFacultyId);
							if(valueArray.indexOf(currentFacultyRecord.get('id'))!="-1"){
								currentItem.classList.remove("disabledComboItem")
							}
							else{
								currentItem.classList.add("disabledComboItem");
							}
						});
						
					}
					
				}
			}
		},{
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});