Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ProgramCourseFilters', {
	extend: 'Ext.form.Panel',
	alias: 'widget.programcoursefilters',
	autoScroll: true,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	style: 'margin-bottom: 0px !important',
	items: [{
		xtype: 'form',
		width: '100%',
		cls:'customSearchPanel',
		items: [{
			xtype:'hidden',
			name:'resourceTypeId'
		},{
			xtype:'hidden',
			name:'locationId'
		},{
			xtype:'hidden',
			name:'courseVariantId'
		},{
			xtype : 'radiogroup',
			itemId : 'courseSectionTypeRadio',
			items : [{
				boxLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
				name : 'sectionType',
				inputValue : 'PBS',
				checked : true
			},{
				boxLabel : getCourseTxCommonTranslation('COURSE_SECTION'),
				name : 'sectionType',
				inputValue : 'CBS'
			} ]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'programBatchCoursePeriodContainerA',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'program',
				itemId : 'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store : Ext.create('Academia.store.common.AssignedProgramStore'),
				displayField : 'code',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}


			},{
				xtype: 'customcombobox',
				name: 'batch',
				itemId : 'batchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'batchName',
				valueField : 'id',
				disabled : true,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'programPeriodName',
				valueField : 'id',
				disabled : true,
				editable : false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'ACADEMIC_TERM',
				itemId : 'academicTerm',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				editable : false,
				hidden : true
			},{
				xtype: 'customcombobox',
				name: 'cbsProgram',
				itemId : 'cbsProgramId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField : 'valueCode',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'cbsBatch',
				itemId : 'cbsBatchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				editable : false
				
			}
			]},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'courseComponentSectionContainer_1A',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{

				xtype: 'customcombobox',
				name: 'cbsPeriod',
				itemId : 'cbsPeriodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				editable : false
			
				
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
				name : 'cbsSectionGroupId',
				itemId : 'cbsSectionGroupId',
				store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupStore'),
				displayField : 'value',
				valueField : 'id',
				typeAhead : false,
				editable : false,
				forceSelection : true,
				width: 256,
				allowBlank:true,
			},{
				xtype: 'customcombobox',
				name: 'section_1',
				itemId: 'courseSection_Id_1',
				fieldLabel: getCommonTranslation('SECTION'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
	        	displayField : 'sectionCode',
	        	valueField : 'id',
				disabled:true,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'course_1',
				itemId: 'courseId_1',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store : Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				queryParam:'name',
				minChars:3,
				typeAhead: false,
				forceSelection : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}/{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'course',
				itemId: 'courseId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store : Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
				displayField : 'value',
				valueField : 'id',
				hidden:true,
				queryParam:'name',
				autoloadStore: false,
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'multiselectcombofield',
				name: 'section',
				itemId: 'courseSection_Id',
				fieldLabel: getCommonTranslation('SECTION'),
				store : Ext.create('Academia.store.programCourseDashboard.ParameterisedCourseSectionStore'),
				displayField : 'value',
				valueField : 'id',
				autoloadStore: false,
				disabled:true,
				editable : false,
				queryMode:'local',
				cls:'ProgramCourseMultiselectField',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'faculty',
				itemId: 'facultyId',
				fieldLabel:getCourseTxCommonTranslation('FACULTY'),
				store : Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				autoloadStore: false,
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'homeRoom',
				itemId: 'homeRoom',
				fieldLabel: getCourseTxCommonTranslation('CVG_ROOM'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				autoloadStore: false,
				queryParam:'name',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	    	  	xtype: 'customcombobox',
	            fieldLabel: getProgramandcourseTranslation('WEEKDAY'),
	            name: 'weekday',
	            valueField: 'name',
	            displayField: 'value',
	            itemId: 'weekday',
	            store : Ext.create('Academia.store.transport.serviceRoute.WeekDays'),
	            editable: false,
	            queryMode: 'local',
	            listeners: {
	            	beforerender: function(combo){
	            		var store = Ext.create('Academia.store.common.WeekDaysComboStore');
	            		combo.bindStore(store);
	            	}
	            }
			},{
				xtype: 'multiselectcombofield',
				name: 'facultyDepartment',
				itemId: 'facultyDepartmentId',
				fieldLabel:getCommonTranslation('FACULTY_DEPARTMENT'),
				store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ParamatrizedFacultyDepartement'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'query',
				autoloadStore: false,
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				itemId:'withoutMasterTimetableId',
				boxLabel: getCommonTranslation('COURSES_WITHOUT_MASTER_TIMETABLE'),
				name: 'withoutMasterTimetable',
				inputValue : true,
				uncheckedValue: false 
			}]

		},{
			xtype: 'fieldcontainer',
			width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'quickSearchId',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});