/**
 * Dharmendra.prajapati
 */


Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoverageDetails',{
	extend: 'Ext.window.Window',
	alias: 'widget.coveragedetails',
	title:getCourseTxCommonTranslation('ADD_CVG_DETAILS'),
	modal:true,
	maxHeight: 600,
    autoScroll: true,
	items: [{
		xtype: 'form',
		id:'coverageDetails_Id',
		itemId:'coverageDetail',
        autoScroll:true,
        margin: 0,
//        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top'
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
		items: [{
				xtype: 'hidden',
				name: 'id'
			},
			{
				 xtype : 'fieldcontainer',
	        	 layout : 'hbox',
	        	 defaults : {
	        		 labelAlign : 'top',
	        		 width: 256
	        	 },
	        	 layout : {
	        		 type : 'hbox'
	        	 },
				items:[{
					xtype: 'customcombobox',
					name: 'courseTopic',
					fieldLabel: getCourseTxCommonTranslation('CVG_TOPIC'),
					store:'',
					displayField:'value',
					valueField:'id',
					typeAhead:true
				},{
					xtype: 'textfield',
					name: 'session',
					readOnly:true,
					itemId:'session_Id',
					fieldLabel: getCourseTxCommonTranslation('CVG_SESSION')
			    }]
			},
			{
				 xtype : 'fieldcontainer',
	        	 layout : 'hbox',
	        	 defaults : {
	        		 labelAlign : 'top',
	        		 width: 256
	        	 },
	        	 layout : {
	        		 type : 'hbox'
	        	 },
	        	 items:[
	        	        {
	        	        	xtype: 'datefield',
	        	        	itemId:'sessionDateId',
	        	        	name: 'sessionDate',
	        	        	//format: 'd-m-Y',
	        	        	//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,	
	        	        	fieldLabel: getCourseTxCommonTranslation('CVG_DATE_OF_SESSION'),
//	        	        	value: new Date(),
//	        	        	minValue: new Date(),
	        	        	allowBlank : false,
	    					listeners: {
	    						render: function(obj) {
	    							obj = dateFormatRender(obj);						
	    							obj.setValue(new Date());
	    						}
	    					}
	        	        },{
	    					xtype: 'textfield',
	    					name: 'studentNum',
//	    					itemId:'studentNumId',
	    					readOnly:true,
	    					hidden:true,
	    					fieldLabel: getCourseTxCommonTranslation('NO_OF_STUDENT')
	    			    }
	        	        ]
	        	 },{
				 xtype : 'fieldcontainer',
	        	 layout : 'hbox',
	        	 defaults : {
	        		 labelAlign : 'top',
	        		 width: 256
	        	 },
	        	 layout : {
	        		 type : 'hbox'
	        	 },
				items:[{
			    	   xtype : 'timefield',
						name : 'slotFrom',		
						itemId : 'slotFrom',			
						fieldLabel:getCourseTxCommonTranslation('CVG_TIME_FROM'),
						format:'g:i A',
						vtype: 'timerange',
						endTimeField : 'slotTo',
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'slotTo',
						itemId : 'slotTo',	
						fieldLabel : getCourseTxCommonTranslation('CVG_TIME_TO'),
						format:'g:i A',
						vtype: 'timerange',
						startTimeField : 'slotFrom',
						allowBlank:false
			       }]
			},{
					xtype: 'customcombobox',
					name: 'classRoom',
					width: 256,
					itemId:'classRommId',
					fieldLabel: getCourseTxCommonTranslation('CVG_ROOM'),
					store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoomStore',
					displayField:'code',
					valueField:'id',
					queryMode:'local',
					typeAhead:true,
					disabled:true,
					allowBlank:false,
					forceSelection:true
				},{
			    xtype: 'multiselectcombofield',
				name: 'assignFaculty',
				itemId:'assignFacultyId',
				width: 536,
				fieldLabel: getCourseTxCommonTranslation('CVG_ASSIGN_FACULTY'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.FacultyByTopicAndSection',
				displayField:'value',
				valueField:'id',
				disabled:true,
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				addAllSelector: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = 'auto';
							setTimeout(function(){
								picker.el.dom.style.width='auto';
								picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
							},10);
						},
						refresh: function( boundList, eOpts ){
							try{
								var combo = boundList.up('combo');
								var allItems = combo.listKeyNav.boundList.all.elements;
								var selectedDate = '';
								var comboStore = combo.getStore();
								if(typeof combo.getValue() != "string" && combo.getValue().length<3){
									Ext.each(allItems, function(currentItem){
										currentItem.classList.remove("disabledComboItem");
									});
								}
								else if(combo.getValue().length==3){
									var valueArray = [];
									Ext.each(combo.getValue(), function(currentValue){
										if(typeof currentValue=="object"){
											valueArray.push(currentValue.get('id'));
										}
										else{
											valueArray.push(currentValue);
										}
									});
									
									Ext.each(allItems, function(currentItem){
										var currentFacultyId = currentItem.viewRecordId;
										var currentFacultyRecord = comboStore.findRecord('id',currentFacultyId);
										if(valueArray.indexOf(currentFacultyRecord.get('id'))!="-1"){
											currentItem.classList.remove("disabledComboItem")
										}
										else{
											currentItem.classList.add("disabledComboItem");
										}
									});
									
								}
							}
							catch(e){}
						}
					}
				},
				listeners:{
					beforeselect:function(selModel,record,index){
						var combo = selModel.view.field;
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							if(typeof combo.getValue()=="object" && combo.getValue().length==3){
								return false;
							}
						}
					},
					change: function(combo, newValue, oldValue, eOpt){
						var allItems = combo.listKeyNav.boundList.all.elements;
						var selectedDate = '';
						var comboStore = combo.getStore();
						if(typeof combo.getValue() != "string" && combo.getValue().length<3){
							Ext.each(allItems, function(currentItem){
								currentItem.classList.remove("disabledComboItem");
							});
						}
						else if(combo.getValue().length==3){
							var valueArray = [];
							Ext.each(combo.getValue(), function(currentValue){
								if(typeof currentValue=="object"){
									valueArray.push(currentValue.get('id'));
								}
								else{
									valueArray.push(currentValue);
								}
							});
							
							Ext.each(allItems, function(currentItem){
								var currentFacultyId = currentItem.viewRecordId;
								var currentFacultyRecord = comboStore.findRecord('id',currentFacultyId);
								if(valueArray.indexOf(currentFacultyRecord.get('id'))!="-1"){
									currentItem.classList.remove("disabledComboItem")
								}
								else{
									currentItem.classList.add("disabledComboItem");
								}
							});
							
						}
						
					}
				}
			},{
				xtype : 'fieldcontainer',
	        	layout : 'hbox',
				items:[{
					xtype:'displayfield',
					name : 'sessionStatus',
					fieldLabel: getCourseTxCommonTranslation('SESSION_STATUS'),
					value : getCourseTxCommonTranslation('HW_ACTIVE')
				}]
			},{
				xtype: 'checkboxfield',
	            width: 'auto',
	            labelAlign: 'right',
	            boxLabel: getCourseTxCommonTranslation('CVG_OPTIONAL_SESSION'),
	            name: 'optionalSession',
	            inputValue : true,
	            uncheckedValue:false 
			},{
				xtype: 'checkboxfield',
	            width: 'auto',
	            labelAlign: 'right',
	            boxLabel: getCourseTxCommonTranslation('CVG_SESSION_ATTENDANCE'),
	            name: 'whetherAttendanceToBeEntered',
	            inputValue : true,
	            uncheckedValue: false
			},{
				xtype: 'checkboxfield',
	            width: 'auto',
	            labelAlign: 'right',
	            boxLabel: getCourseTxCommonTranslation('CVG_SESSION_PLANNED'),
	            name: 'sessionPlanned',
	            inputValue : true,
	            uncheckedValue: false,
	            checked : true,
	            disabled : true
			},{
				xtype:'fieldcontainer',
//	        	width:'100%',
	        	cls:'windowBtnPos',	
//			  layout:'hbox',
//			  style:{marginTop:'10px'},
			  items: [{
					xtype: 'button',
					action: 'Submit',
					text: getCourseTxCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
		      	 },{
					xtype: 'button',
					text: getCourseTxCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
			      }]
		   }]
	  }]     
});