Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.ExtendMasterTimeTableForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.extendmastertimetableform',
	autoScroll:true,
	plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	standardSubmit : false,
	cls:'customSearchPanel extendMasterTimeTableCls',
	items : [{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'customcombobox',
			name : 'sectionType',
			itemId:'sectionType',
			fieldLabel : getCommonTranslation('EXTEND_TIMETABLE_FOR'),		
			store:Ext.create('Academia.store.course.SectionTypeForExtendTimetableStore'),
			valueField : 'id',
			displayField : 'value',
			triggerAction : 'all',
			editable : false
		}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype:'hidden',
				name:'whetherDayWiseSchedule',
				itemId:'whetherDayWiseScheduleId'
			},{
				xtype : 'customcombobox',
				name : 'calendar',
				itemId:'calendarId',
				fieldLabel : getProgramandcourseTranslation('CALENDAR'),
				store : 'facilitiesresources.resourcemaster.MappedCalenderStore',
				displayField : 'value',
				valueField : 'id',
				queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				allowBlank: false,
				anyMatch: true	
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH'),
				name : 'batch',
				itemId : 'batchId',
				width: 536,
				disabled:true,
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'batch',
				valueField : 'id',
				forceSelection : true,
				queryParam:'qry',
				minChars:3,
				typeAhead:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{batch}'  +
		                    '</div>';
		                }
		            }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'ACADEMIC_TERM',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				hidden : true,
				queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				allowBlank: false,
				anyMatch: true	
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'course',
				itemId: 'courseId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.CourseByCalendar'),
				displayField:'courseCodeName',
				valueField:'courseId',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				disabled:true,
				hidden: true,
				forceSelection : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'component',
				itemId: 'componentSectionId',
				fieldLabel: getCommonTranslation('COMPONENT'),
				store:Ext.create('Academia.store.course.coursetopic.CourseComponentStore'),
				displayField:'value',
				valueField:'id',
				hidden : true,
				typeAhead : false,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'courseSection',
				itemId: 'courseSection_Id',
				fieldLabel: getCommonTranslation('SECTION'),
				store:Ext.create('Academia.store.attendance.SectionByCourseNComponent'),
				displayField:'sectionCode',
				valueField:'sectionId',
				hidden : true,
				disabled:true,
				queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				allowBlank: false,
				anyMatch: true	
			},{
				xtype: 'hidden',
				name: 'courseVariantId',
				itemId: 'courseVariantId'
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'period',
				itemId : 'periodId',
				disabled:true,
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.PeriodSection'),
				displayField : 'value',
				valueField : 'id',
				queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				allowBlank: false,
				anyMatch: true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				name : 'section',
				itemId : 'sectionId',
				store : Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID'),
				displayField : 'sectionCode',
				valueField : 'sectionId',
				disabled:true,
				queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				allowBlank: false,
				anyMatch: true
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 536,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'multiselectcombofield',
				name: 'academicTermWiseProgBatch',
				itemId: 'academicTermWiseProgBatch',
				fieldLabel: getCourseTxCommonTranslation('PROGRAM_BATCH'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchByAcademicTermStore'),
				displayField : 'batch',
				valueField : 'id',
				queryParam:'qry',
				minChars:3,
				typeAhead:true,
				forceSelection : true,
				hideTrigger:false,
				triggerAction: 'all',
				cls:'ProgramCourseMultiselectField',
				hidden: true,
				autoloadStore: false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{batch}'  +
		                    '</div>';
		                }
		            }
			}]
		},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 536
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'academicTermWisePeriod',
			itemId:'academicTermWisePeriod',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ParameterizedPeriodByBatch'),
        	displayField : 'value',
        	valueField : 'id',
			disabled:true,
			hidden:true,
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			allowBlank:true,
			hideTrigger:false,
			autoloadStore: false,
			triggerAction: 'all',
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]  
	},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'multiselectcombofield',
				name: 'academicTermWiseCourse',
				itemId: 'academicTermWiseCourse',
				width: 536,
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store:Ext.create('Academia.store.course.CourseComboByCriteriaStore'),
				queryParam:'courseName',
                displayField: 'value',
                valueField: 'id',
                autoloadStore: false,
                minChars:3,
				typeAhead:true,
				disabled:true,
				hidden: true,
				forceSelection : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
                        	'{code} / {value}'+ 
                        '</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'academicTermWiseSection',
				itemId: 'academicTermWiseSection',
				fieldLabel: getCommonTranslation('SECTION'),
				store:Ext.create('Academia.store.attendance.SectionByCourseNComponent'),
				displayField:'sectionCode',
				valueField:'sectionId',
				autoloadStore: false,
				hidden : true,
				disabled:true,
				typeAhead : false,
				forceSelection : true,
				hideTrigger:false,
				triggerAction: 'all',
				cls:'ProgramCourseMultiselectField',
				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
                        	' {sectionCode}'+ 
                        '</div>';
					}
				}
			},{
				xtype: 'hidden',
				name: 'courseVariantId',
				itemId: 'courseVariantId'
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				vtype : 'searchDaterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				vtype : 'searchDaterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
			},{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
    			type : 'hbox'
    		},
    		style:{
    		'margin-left':'-50px !important'	
    		},
    		
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items : [{
				xtype : 'button',
				text : getCommonTranslation('VIEW_SCHEDULES'),
				itemId : 'viewSchedulesBtnItemId',
				buttonAlign : 'left',
				style:{
    				marginLeft:'12px !important',
    			},
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				disabled:true,
			    formBind : true
			},{
				xtype : 'button',
				text : getProgramandcourseTranslation('GENERATE'),
				itemId : 'generateDetailedId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				disabled:true,
			    formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui : 'CustomBtnCancel',
				itemId:'resetBtn',
	   		    scale : CONSTANTS.BUTTONSIZE,
			}]
		}]
});
