/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterSearchFilter',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.mastersearchfilter',
	plugins : "formlabelrequired",
	autoScroll : true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'form',
        border:false,
		width : '100%',
		cls:'customSearchPanel',
		items : [{
			/*xtype:'panel',
			width: '100%',
			cls:'panelNoSpace customSearchInnerPanel',
			items:[{*/
				xtype: 'radiogroup',
				itemId:'sectionTypeId',
				columns: 2,
				vertical: false,				
				items: [{
					boxLabel: getProgramandcourseTranslation('PROGRAM_BATCH_SECTION'),
					name: 'sectionType',
					inputValue: 'PROGRAM_BATCH_SECTION',
					checked:true
				},{
					boxLabel: getProgramandcourseTranslation('COURSE_SECTION'),
					name: 'sectionType',
					inputValue: 'COURSE_SECTION'
				}]
			//}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype:'hidden',
				name:'whetherDayWiseSchedule',
				itemId:'whetherDayWiseScheduleId'
			},{
				xtype : 'customcombobox',
				name : 'calendar',
				itemId:'calendarId',
				fieldLabel : getProgramandcourseTranslation('CALENDAR'),
				store : 'facilitiesresources.resourcemaster.MappedCalenderStore',
				displayField : 'value',
				valueField : 'id',
				allowBlank : false,
				editable:true,
				queryMode: 'local'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				name : 'ACADEMIC_TERM',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				editable:true,
				queryMode: 'local'
			}]
		},{

			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype:'hidden',
				name:'whetherDayWiseSchedule',
				itemId:'whetherDayWiseScheduleId'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH'),
				name : 'batch',
				itemId : 'batchId',
				width: 536,
				disabled:true,
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'batch',
				valueField : 'id',
				allowBlank : false,
				forceSelection : true,
				queryParam:'qry',
				minChars:3,
				typeAhead:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{batch}'  +
		                    '</div>';
		                }
		            }
			}]
		
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			style:{
				'min-height': '0px !important;'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'course',
				itemId: 'courseId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.CourseByCalendar',
				displayField:'courseCodeName',
				valueField:'courseId',
				allowBlank: false,
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				disabled:true,
				hidden: true,
				forceSelection : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'component',
				itemId: 'componentSectionId',
				fieldLabel: getCommonTranslation('COMPONENT'),
				store:'course.coursetopic.CourseComponentStore',
				displayField:'value',
				valueField:'id',
				allowBlank: true,
				hidden : true,
				typeAhead : false,
				editable:false
			},{
				xtype: 'customcombobox',
				name: 'courseSection',
				itemId: 'courseSection_Id',
				fieldLabel: getCommonTranslation('SECTION'),
				store:'attendance.SectionByCourseNComponent',
				displayField:'sectionCode',
				valueField:'sectionId',
				allowBlank: false,
				hidden : true,
				disabled:true,
				typeAhead : false,
				editable:true,
				queryMode: 'local'
			},{
				xtype: 'hidden',
				name: 'courseVariantId',
				itemId: 'courseVariantId'
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'period',
				itemId : 'periodId',
				disabled:true,
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'programPeriodName',
				valueField : 'id',
				allowBlank : false,
				typeAhead : true,
				editable:true,
				queryMode: 'local'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				name : 'section',
				itemId : 'sectionId',
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'sectionCode',
				valueField : 'id',
				allowBlank : false,
				disabled:true,
				typeAhead : true,
				editable:true,
				queryMode: 'local'
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout: 'hbox',
			items : [{
				xtype : 'button',
				text : getProgramandcourseTranslation('CREATE_VIEW_MASTER_TIME_TABLE'),
				itemId : 'viewCalanderId',
				//buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui : 'CustomBtnCancel',
				itemId:'resetBtn',
	   		    scale : CONSTANTS.BUTTONSIZE,
			},{
				xtype: 'button',
				text: getProgramandcourseTranslation('DOWNLOAD_TEMPLATE'),
				itemId: 'downoladtemplate',
				formBind:true,
				ui: 'CustomBtnThird',
				hidden: true
			},{
				xtype: 'button',
	    	   	 text: getProgramandcourseTranslation('UPLOAD_MASTER_TIME_TABLE'),
	    	     itemId: 'uploadtemplate',
	    	     hidden:true,
	    	     ui : 'CustomBtnThird'
			}]
		}]
	},{
		xtype: 'panel',
		itemId: 'masterTimeTableMainPanel',
		cls: 'masterTimeTableMainPanelCls',
		hidden:true
	} ]
});
