/*
 * @author Akshay Sharma
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionGroupFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursesectiongroupfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.sectionmanagement.AcademyLocationsByUserStore'),
			width: 536,
			valueField : 'id',
			displayField : 'value',
			//allowBlank : false,
			//minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			editable:true,
			//queryParam:'qry',
			queryMode:'local',
			anyMatch : true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : false,
			forceSelection : true,
			store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			hidden : false,
			width: 256,
			editable : true, 
			queryMode:'local',
			anyMatch : true
		}]
	},
		
		{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
			name : 'sectionGroupId',
			itemId : 'sectionGroupId',
			store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroup'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : false,
			forceSelection : true,
			queryMode: 'local',
			editable : true,
			anyMatch : true
		},{
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:Ext.create('Academia.store.programCourseDashboard.ProgramsBySectionGroupIdStore'),
			displayField:'valueCode',
			valueField:'id',
			typeAhead:false,
			minChars:3,
			forceSelection:true ,
			queryParam:'name',
		    typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchId',
			store: Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupBatchStore'),
			valueField: 'id',
			displayField: 'code',
			disabled : true,
			typeAhead:false,
			forceSelection:true,
			queryMode: 'local',
			editable : true,
			anyMatch : true
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodId',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupPeriodStore'),
			valueField: 'id',
			displayField: 'value',
			disabled : true,
			typeAhead:true,
			forceSelection:true,
			queryMode: 'local',
			editable : false 
		},{
			xtype : 'customcombobox',
			name : 'courseId',
			itemId : 'courseId',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupCourseStore'),
			displayField : 'valueCode',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			minChars:3,
			style:{
				width: 536,
		    },
		    queryParam:'name',
		    typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},{
			xtype : 'customcombobox',
			name : 'SGCourseVariantId',
			itemId : 'SGCourseVariantId',
			fieldLabel : getCommonTranslation('COURSE_VARIANT'),
			store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupCourseVariantStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			typeAhead : false,
			forceSelection : true,
			queryMode: 'local',
			editable : true,
			anyMatch : true
		}]  
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusId',
			value : '2',
			fieldLabel: getCourseTxCommonTranslation('STATUS'),
			 store: Ext.create('Ext.data.Store', {
                 fields: ['id', 'value'],
                 data: [{
                     id: '1',
                     value: getCourseTxCommonTranslation('READY_TO_ENROLL')
                 }, {
                     id: '2',
                     value: getCourseTxCommonTranslation('PENDING_FOR_ENROLLMENT')
                 }]
             }),
             displayField: 'value',
             valueField: 'id',
             forceSelection: true,
             editable: false,
             allowBlank: true
         },{
	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	style:{
	        		marginTop:'25px'
	        	},
	        	itemId:'unmappedSectionGroups',
	        	boxLabel: getCourseTxCommonTranslation('SHOW_UNMAPPED_SECTION_GROUPS'),
	        	name: 'unmappedSectionGroups',
	        	inputValue : true,
	            uncheckedValue: false
	        }]},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			margin: '0 36 0 0'
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});