/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionGroupList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursesectiongrouplist',
	store : 'coursetransaction.sectionmanagement.CourseSectionGroupListing',
	title: getCourseTxCommonTranslation('LIST_OF_SECTION_GROUP'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.sectionmanagement.CourseSectionGroupListing',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCourseTxCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCourseTxCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCourseTxCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCourseTxCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCourseTxCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getCourseTxCommonTranslation('MAP_PROGRAM_PERIOD'),
			itemId:'mapProgramPeriod'	
		},{
			text:getCourseTxCommonTranslation('MAP_COURSE_VARIANTS'),
			itemId:'mapCourseVariants'
		},{
			text:getCourseTxCommonTranslation('UN_MAP_PROGRAM_PERIOD'),
			itemId:'unMapProgramPeriod'	
		},{
			text:getCourseTxCommonTranslation('UN_MAP_COURSE_VARIANTS'),
			itemId:'unMapCourseVariants'
		},{
			text:getCourseTxCommonTranslation('READY_TO_ENROLL'),
			itemId:'readyToEnroll'	
		},{
			text:getCourseTxCommonTranslation('PENDING_FOR_ENROLLMENT'),
			itemId:'pendingForEnroll'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header : getCourseTxCommonTranslation('SECTION_CODE'),
		dataIndex : 'sectionGroupName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PRINT_NAME'),
		dataIndex : 'printName',
		flex:1

	},{
		header : getCourseTxCommonTranslation('HOME_ROOM'),
		dataIndex : 'homeRoom',
		flex:1
	},{
		header : getCourseTxCommonTranslation('CAPACITY'),
		dataIndex : 'maxCapacity',
		flex:1
	},{
		header : getCourseTxCommonTranslation('NO_OF_PROGRAM_PERIOD'),
		dataIndex : 'periodCount',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('NO_OF_COURSE_VARIANT'),
		dataIndex : 'courseVariantCount',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('ENROLLED_STUDENT'),
		dataIndex : 'enrollmentCount',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('STATUS'),
		dataIndex : 'whetherReadyToEnroll',
		flex:1,
		renderer: function(value) {
	        return value ? getCourseTxCommonTranslation('READY_TO_ENROLL') : getCourseTxCommonTranslation('PENDING_FOR_ENROLLMENT');
	    }
	}]
});