/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionGroupWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.coursesectiongroupwin',
	title:getCourseTxCommonTranslation('SECTION_GROUP'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'coursesectiongroupwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			itemId: 'id',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'sectionGroupName',
				itemId:'sectionGroupName',
				allowBlank:false,
				fieldLabel: getCourseTxCommonTranslation('SECTION_GROUP_NAME'),
				maxLength:55,
		    	enforceMaxLength : true
			},{
				xtype: 'textfield',
				name: 'printName',
				itemId:'printName',
				fieldLabel: getCourseTxCommonTranslation('PRINT_NAME'),
				maxLength:55,
		    	enforceMaxLength : true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'coordinatorId',
				itemId: 'coordinatorId',
				fieldLabel: getCourseTxCommonTranslation('SECTION_COORDINATOR'),
				store:'coursetransaction.sectionmanagement.ClassTeacherStore',
				displayField:'value',
				valueField:'id',
				queryParam:'nameOrCode',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
	            forceSelection:true,
	            allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
			},{	
				xtype: 'customcombobox',
				name: 'homeRoomId',
				itemId:'homeRoomId',
				fieldLabel: getCourseTxCommonTranslation('HOME_ROOM'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.InternalRoomStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
		}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{	
				   xtype: 'numberfield',
	 			   itemId: 'maxCapacity',
	 			   name: 'maxCapacity',
	 			  fieldLabel: getCourseTxCommonTranslation('CAPACITY'),
	 			   mouseWheelEnabled:false,
	 			   allowDecimals:false,
	 			   maxLength: 20,
	 			   minValue:0,
	 			   maxValue : 5000,
	 			   hideTrigger:true,
	 			   allowExponential:false,
	 			   allowDecimals:false
				},/*{
					xtype: 'nestedJsonCombo',
					name: 'succedingSectionGroupId',
					itemId:'succedingSectionGroupId',
					fieldLabel: getCourseTxCommonTranslation('SUCCEEDING_SECTION_GROUP'),
					store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SuccedingSection',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
			}*/]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});