/**
 * @author Deepak Nigam
 * 
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.DownloadSectionTransferForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadsectiontransferform',
	//plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
	items : [{
		xtype : 'radiogroup',
		itemId:'sectionTypeItemId',
		style:{
			marginLeft:'8px'
		},
		defaults: {
			flex: .1
		},
		items : [{
			boxLabel : getCommonTranslation('PROGRAM_BATCH_SECTION'),
			name : 'sectionType',
			inputValue : 'ProgramBatchSection',
			checked : true

		},{
			boxLabel : getCommonTranslation('COURSE_SECTION'),
			name : 'sectionType',
			inputValue : 'CourseSection'
		}]
	},
	   {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [ {
            xtype: 'customcombobox',
            name: 'academicTerm_Name',	      
            itemId:'academicTerm',
            width: 256,
            editable: false,
            displayField: 'value',
            hidden:true,
            valueField: 'id',
            store: Ext.create('Academia.store.user.UserAcademyTermsByALStore'),
            queryMode: 'local',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            allowBlank: true,
           
        }]
	},
	 {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [{
      	  xtype: 'customcombobox',
          name: 'PROGRAM_NAME_Pbs',
          itemId: 'program_ID_Pbs',
          fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//          translationKey: 'PROGRAM',
          width: 536,
          valueField: 'id',
          displayField: 'valueCode',
//          store:'Academia.store.student.report.ProgramWithAcademicTermStore',
          store: Ext.create('Academia.store.student.report.ProgramWithAcademicTermStore'),
          allowBlank: false,
          forceSelection:true,
          hideTrigger:false,
          typeAhead:true,
    	  triggerAction: 'all',
          minChars:3,
          emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
          forceSelection:true,
          queryParam:'programName',
            listConfig: {
    			  listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                        '{value}'  +
                        '</div>';
                    }
                } 			            	
    },
    {
        xtype:'customcombobox',
        name: 'BATCH_NAME_Pbs',
        itemId: 'batch_ID_Pbs',
        fieldLabel: getPersonModuleTranslation('BATCH'),
        width: 256,
        editable: false,
        displayField: 'value',
        allowBlank: false,
        disabled:true,
        valueField: 'id',
//        store:'enquiry.AcademicBatchStore',
        store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
        typeAhead:true,
    }]},
    {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [ {
            xtype: 'customcombobox',
            name: 'PERIOD_NAME_Pbs',	      
            itemId:'period_ID_Pbs',
            disabled:true,
            width: 256,
            editable: false,
            displayField: 'value',
            valueField: 'id',
//            store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            queryMode: 'local',
            fieldLabel: getPersonModuleTranslation('PERIOD'),
            allowBlank: false,
        }]
	},
	{
			xtype : 'fieldcontainer',
			items : [{
			            xtype: 'fieldcontainer',
			            width: '100%',
			            layout: 'hbox',
			            defaults: {
			                labelAlign: 'top'
			            },
			            items: [{
			            	  xtype: 'multiselectcombofield',
				              name: 'PROGRAM_NAME_COURSE',
				              itemId: 'program_ID',
				              fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				              translationKey: 'PROGRAM',
				              width: 536,
				              valueField: 'id',
				              displayField: 'valueCode',
				              store: Ext.create('Academia.store.student.report.ProgramWithAcademicTermStore'),
				              forceSelection:true,
					          hideTrigger:false,
					          typeAhead:true,
					    	  triggerAction: 'all',
					    	  disabled:true,
					    	  hidden:true,
					    	  allowBlank: false,
					    	  cls:'receiptHeaderMultiselect',
					          minChars:3,
					          emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
					          queryParam:'programName',
					            listConfig: {
				        			  listeners: {
				        					beforeshow: function(picker) {
				        						picker.minWidth = picker.up('combobox').getSize().width;
				        					}
				        				},
				                        loadingText: getCommonTranslation('SEARCHING'),
				                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				                        getInnerTpl: function() {
				                            return '<div class="search-item">' +
				                            '{value}'  +
				                            '</div>';
				                        }
				                    } 			            	
			            },{
			                xtype:'multiselectcombofield',
			                name: 'BATCH_NAME_COURSE',
			                itemId: 'batch_ID',
			                fieldLabel: getPersonModuleTranslation('BATCH'),
			                width: 256,
			                disabled:true,
			                editable: false,
			                cls:'receiptHeaderMultiselect',
			                hidden:true,
			                displayField: 'value',
			                allowBlank: false,
			                valueField: 'id',
//			                store:'enquiry.AcademicBatchStore',
			                store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
					            listConfig: {
				        			  listeners: {
				        					beforeshow: function(picker) {
				        						picker.minWidth = picker.up('combobox').getSize().width;
				        					}
				        				},
				                        loadingText: getCommonTranslation('SEARCHING'),
				                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				                        getInnerTpl: function() {
				                            return '<div class="search-item">' +
				                            '{value}'  +
				                            '</div>';
				                        }
				                    } 
			            }]
			        },{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					labelAlign: 'top'
				},
				items :[{
	                xtype:'multiselectcombofield',
	                name: 'PERIOD_NAME_Course',	      
	                itemId:'period_ID',
	                cls:'receiptHeaderMultiselect',
	                allowBlank: false,
	                disabled:true,
	                width: 256,
	                editable: false,
	                displayField: 'value',
	                valueField: 'id',
	                store: Ext.create('Academia.store.course.readingmaterial.SectionTransferPeriodStore'),
	                //queryMode: 'local',
	                fieldLabel: getPersonModuleTranslation('PERIOD'),
	                hidden:true,
	                listConfig: {
	        			  listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	                        loadingText: getCommonTranslation('SEARCHING'),
	                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                        getInnerTpl: function() {
	                            return '<div class="search-item">' +
	                            '{value}'  +
	                            '</div>';
	                        }
	                    } 
	            },
	            {
	                xtype: 'multiselectcombofield',
	                name: 'courseCodeName_Course',	      
	                itemId:'courseCodeName',
	                disabled:true,
	                width: 536,
	                cls:'receiptHeaderMultiselect',
	                editable: false,
	                displayField: 'value',
	                valueField: 'id',
//	                store:'Academia.store.programCourseDashboard.ParameterisedCoursesStore',
	                store:Ext.create('Academia.store.programCourseDashboard.ParameteriseCourseForSectionTransferStore'),
	                queryMode: 'local',
	                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
	                hidden:true,
	                allowBlank: true,
	                minChars:3,
			        emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
			        listConfig: {
	        			  listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	                        loadingText: getCommonTranslation('SEARCHING'),
	                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                        getInnerTpl: function() {
	                            return '<div class="search-item">' +
	                            '{value}'  +
	                            '</div>';
	                        }
	                    }
	            }
	            ]},
	            {
					xtype: 'fieldcontainer',
					layout: 'hbox',
					width: '100%',
					defaults: {
						labelAlign: 'top'
					},
					items :[{
		                xtype: 'multiselectcombofield',
		                name: 'courseVarient_Course',	      
		                itemId:'courseVarient',
		                disabled:true,
		                cls:'receiptHeaderMultiselect',
		                width: 536,
		                editable: false,
		                hidden:true,
		                displayField: 'courseVariantCode',
		                valueField: 'id',
		                store: Ext.create('Academia.store.course.coursevariants.CourseVariantSectionTransferStore'),
		                queryMode: 'local',
		                fieldLabel: getCommonTranslation('COURSE_VARIANT'),
		                allowBlank: true,
		                minChars:3,
				        emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
		            },
		           
		            ]},
	            {
					xtype: 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					cls: 'customSearchPanelBtnsFieldContainerCls',
					style:{
						'margin-left':'-50px !important'
					},
					items: [{
			           	 xtype: 'button',
			        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			             itemId: 'programBatchDownoladBtnId',
			             formBind : true,
			             ui: 'CustomBtnSubmit'
			        },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
				}]
	}]
});
