/**
 *  @author Deepak S
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.ManageCourseSectionAddProgramPeriodGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.managecoursesectionaddprogramperiodgrid',
	title : getCommonTranslation('PROGRAM_BATCH'),
	store: 'program.ManageCourseSectionProgramsPeriodStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	//border: true,
	dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store: 'program.ManageCourseSectionProgramsPeriodStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitMapping',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE,
		margin: '0 24 0 0'
	},{
		xtype: 'customcombobox',
		name: 'programbatchsearchcombo',
		itemId:'programbatchsearchcombo',
		store: Ext.create('Academia.store.program.FindProgramAndPeriodWithBatchStore'),
		valueField: 'id',
		displayField: 'locationName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'programName',
		queryMode: 'remote',
		width:256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	},{
        		xtype: 'radiogroup',
        		itemId:'whetherOptionalItemId',
        		name:'whetherOptionalItem',
        		width: 400,
        		defaults: {
           		 flex: 1
           	 	},
        		columns: 2,
        		allowBlank: false,
        		//style:'margin-left :20px;',
        		fieldLabel: getCommonTranslation('COURSE_TYPE'),
        		labelSeparator : ': <span class="required" style="color:red"> *</span>',
        		items :[{ 
						boxLabel: getCommonTranslation('MANDATORY'),
						name:'whetherOptional', 
						inputValue: false,
						checked:true
				     },{ 
					    boxLabel: getCommonTranslation('OPTIONAL'),
	                    name:'whetherOptional', 
                        inputValue: true
                      }]
           	 }],
	columns: [{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1	 
	}]
});