/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programbatchsectiongrid',
	store : 'coursetransaction.sectionmanagement.ProgramBatchSectionStore',
	title: getCommonTranslation('LIST_OF_PROGRAM_BATCH_SECTION'),
//	translationKey: 'LIST_OF_PROGRAM_BATCH_SECTION',
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
		    store : 'coursetransaction.sectionmanagement.ProgramBatchSectionStore',
			displayInfo : true,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')
		}]
	}],
	cls: 'programBatchSectionGridCls',
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
	    xtype : 'button',
	    itemId : 'studentPhotoReport',
	    tooltip : getCourseTxCommonTranslation('STUDENT_PHOTO_REPORT'),
	    text : getCourseTxCommonTranslation('STUDENT_PHOTO_REPORT'),
	    disabled: true
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
 },
	columns: [/*{
		hidden : true,
		dataIndex : 'id'
	},*/{
		header : getCourseTxCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionCode',
		flex:1,
		sortable:true,
		/*renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"'; 
				return val;
			}else{
				return "";
			}
		}*/
	},{
		header : getCourseTxCommonTranslation('PRINT_NAME'),
		dataIndex : 'alternateName',
		flex:1,
		sortable:true,
		/*renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"'; 
				return val;
			}else{
				return "";
			}
		}*/
	},{
		header : getCourseTxCommonTranslation('CLASS_TEACHER'),
		dataIndex : 'classTeacher',
		flex:1,
		sortable:true
	},{
		header : getCourseTxCommonTranslation('HOME_ROOM'),
		dataIndex : 'homeRoom',
		flex:1,
		sortable:true
	},{
		header : getCourseTxCommonTranslation('CAPACITY'),
		dataIndex : 'maxCapacity',
		flex:1,
		sortable:true
	},{
		header : getProgramandcourseTranslation('ENROLLED_STUDENTS'),
		dataIndex : 'enrolled',
		flex:1,
		renderer:function(value){
			if(value!=null && value >0){
			   return '<a  href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('PROGRAM_PERIOD_START'),
		dataIndex : 'programPeriodStart',
		flex:1,
		sortable:true,
		hidden:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('PROGRAM_PERIOD_END'),
		dataIndex : 'programPeriodEnd',
		flex:1,
		sortable:true,
		hidden:true,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
	
});