/**
 * @author Raghavendra.Soni
 */
var courseSectionStudentStore = Ext.create('Academia.store.coursetransaction.sectionmanagement.CourseSectionStudentStore');
Ext.define('Academia.view.coursetransaction.sectionmanagement.StudentCourseSectionEnrollerStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentcoursesectionenrollerstudentgrid',
	store : courseSectionStudentStore,
	title: getProgramandcourseTranslation('ENROLLED_STUDENTS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : courseSectionStudentStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getCourseTxCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden :true
	},{
		header : getCourseTxCommonTranslation('PROGRAM'),
		dataIndex : 'programCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex:1	
	},{
		header : getCourseTxCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('DATE_OF_ENROLLMENT'),
		dataIndex : 'enrolledDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});