/**
 * @author Ravi Choudhary 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.CourseEnrollmentSearchCS', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courseenrollmentsearchcs',
	plugins : "formlabelrequired",
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
//		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE'),
//			translationKey: 'COURSE',
			itemId: 'courseCodeId',
			name: 'COURSE_ID',
			valueField:'id',
			displayField:'valueCode',
			allowBlank:true,
			disabled:false,
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			},
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
//			translationKey: 'COURSE_VARIANT',
			name:'COURSE_VARIENT_ID',
			itemId: 'courseVariantId',
			displayField: 'code',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true,
			allowBlank:true,
			disabled:false,
			hidden:true,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.CoruseVariantSectionStore');
					combo.bindStore(store);
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			name : 'sectionId',
			itemId : 'sectionId',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			forceSelection : true,
			allowBlank : true,
//			hidden : true,
			disabled:true,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.attendance.SectionByCourseNComponent');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('COURSE_TYPE'),
//			translationKey: 'COURSE_TYPE',
			itemId:'courseType',
			name: 'COURSE_TYPE_ID',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.common.OptionMandatoryStore');
					combo.bindStore(store);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width: 256,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : false,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'facultyName',
			itemId: 'facultyItemId',
			fieldLabel:getExaminationTranslation('FACULTY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			hideTrigger:true,
			enableKeyEvents  : 'true',
			forceSelection : true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.coursetransaction.facultytopicassignment.AssignFacultyStore');
					combo.bindStore(store);
				}
			}
		}]
	},{
		xtype: 'checkboxfield',
		width: 'auto',
		labelAlign: 'right',
		itemId:'nonParamCourses',
		name: 'nonParamCourses',
		boxLabel: getCommonTranslation('VIEW_NON_PARAM_COURSE'),
//		translationKey: 'VIEW_NON_PARAM_COURSE',
		inputValue : true,
		uncheckedValue: false,
//		style:{
//		marginTop:'28px'
//		}
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'studentCourseEnrollSearchBtn',
			buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetButton',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
//}]
});