Ext.define('Academia.view.coursetransaction.studentcourseenrollment.ProgramBatchCourseDetailResultGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.programbatchoursedetailresultgrid',
    store: 'coursetransaction.studentenrollment.enrollmentmaster.ProgramBatchCourseDetailGrid',
    title: getCourseTxCommonTranslation('STUDENT_ENROLLMENT_LIST'),
    border: true,
    autoScroll: false,
    refreshStoreData:true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
		itemId : 'dockedItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'coursetransaction.studentenrollment.enrollmentmaster.ProgramBatchCourseDetailGrid',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
 tbar: [{
	 xtype: 'button',
	 itemId: 'btnAdd',
	 text: getCommonTranslation('STUDENT_ENROLLMENT')
 },{
	 xtype: 'button',
	 itemId: 'courseBtnAdd',
	 text: getCommonTranslation('COURSE_ENROLLMENT'),
//	 translationKey: 'COURSE_ENROLLMENT'
 },{ 

	 xtype:'textfield',
	 emptyText: getCommonTranslation('ENTER_THREE_CHAR_BY_COURSE'),
	 width: 300,
	 name:'studentCourseEnrollmentGridSearch',
	 itemId:'studentCourseEnrollmentGridSearch',
	 cls: 'SearchTextFieldWithSmallHeader'
 }],
    columns: [{
        header: getCommonTranslation('PROGRAM'),
//        translationKey: 'PROGRAM',
        dataIndex: 'programName',
        sortable:true,
        flex: 1
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_CODE'),
//        translationKey: 'COURSE_CODE',
        dataIndex: 'courseCode',
        sortable:true,
        hidden:true,
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_NAME'),
//        translationKey: 'COURSE_NAME',
        dataIndex: 'courseName',
        sortable:true,
        flex: 1
    }, {
        header: getCommonTranslation('SECTION'),
        dataIndex: 'sectionCode',
        sortable:true,
        flex: 1
    }, {
    	header: getCommonTranslation('MIN_CAPACITY'),
    	dataIndex: 'minCapacity',
    	sortable:true,
    	hidden:true,
    	flex: 1
    }, {
    	header: getCommonTranslation('MAX_CAPACITY'),
    	dataIndex: 'maxCapacity',
    	sortable:true,
    	hidden:true,
    	flex: 1
    }, {
    	header: getCommonTranslation('SECTION_MIN_ENROLLMENT'),
    	dataIndex: 'minEnrollment',
    	sortable:true,
    	hidden:true,
    	flex: 1,
    	renderer: function(value){
    		if(value == null){
    			return "-";
    		} else{
    			return value;
    		}
    	}
    }, {
    	header: getCommonTranslation('SECTION_MAX_ENROLLMENT'),
    	dataIndex: 'maxEnrollment',
    	sortable:true,
    	hidden:true,
    	flex: 1,
    	renderer: function(value){
    		if(value == null){
    			return "-";
    		} else{
    			return value;
    		}
    	}
    }, {
    	header: getCommonTranslation('COURSE_VARIANT'),
    	dataIndex: 'courseVariantCode',
    	sortable:true,
    	hidden:true,
    	flex: 1
    },{
        header: getCommonTranslation('FACULTY'),
        dataIndex: 'faculties',
        flex: 1
    },{
        header: getCommonTranslation('ALTERNATE_FACULTY'),
        dataIndex: 'alternateFaculties',
        flex: 1
    },{	
        header: getCommonTranslation('COURSE_TYPE'),
//        translationKey: 'COURSE_TYPE',
        dataIndex: 'courseType',
        sortable:true,
        flex: 1,
        renderer: function(value){
        	var greenColor = "<font color='green'>";
    		var darkOrangeColor = "<font color='#D2691E'>";
        	if(value == 'true'){
        		return greenColor+"Optional"+"</font>"; 	
        	}else if(value == 'false'){
        		return darkOrangeColor+"Mandatory"+"</font>";
        	}else {
        		return "";
        	}
        }
    }, /*, {
        header: getCommonTranslation('MAX_CAPACITY'),
        dataIndex: 'sectionMaxCapacity',
        sortable:true,
        hidden:true,
        flex: 	1
    }*/{
        header: getProgramandcourseTranslation('ENROLLMENT_REQ_RECEIVED'),
        dataIndex: 'requestedCount',
        sortable:true,
        flex: 1,
        renderer: function(value){
        	if(value!=null&&value>0){
        		return Ext.String.format("<a href='#'>"+value+"</a>");	
        	}else{
        		return "0";
        	}
        	 
        }
    }, {
        header: getProgramandcourseTranslation('CURRENTLY_ENROLLED'),
        dataIndex: 'enrolledCount',
        sortable:true,
        flex: 1,
        renderer: function(value){
        	if(value!=null&&value>0){
        		return  Ext.String.format("<a href='#'>"+value+"</a>"); 	
        	}else{
        		return "0";
        	}
        	 
        }
    }, {
        header: getProgramandcourseTranslation('ENROLLMENT_REQ_REJECTED'),
        dataIndex: 'rejectedCount',
        sortable:true,
        flex: 1,
        renderer: function(value){
        	if(value!=null&&value>0){
        		return Ext.String.format("<a href='#'>"+value+"</a>");	
        	}else{
        		return "0";
        	}
        	 
        }
    }, {
        header: getProgramandcourseTranslation('DEENROLLED_AFTER_ENROLLMENT'),
        dataIndex: 'deEnrolledCount',
        sortable:true,
        flex: 1,
        renderer: function(value){
        	if(value!=null&&value>0){
        		return Ext.String.format("<a href='#'>"+value+"</a>");	
        	}else{
        		return "0";
        	}
        	 
        }
    }]

});