/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.importStudentCourseEnrollment.DownloadTemplatePBSAndCBS',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadtemplatepbsandcbs',
	plugins : "formlabelrequired",
	autoScroll : true,
	frame: false,
	border:false,
	method : 'POST',
	standardSubmit : false,
	items : [{
			xtype : 'radiogroup',
			itemId : 'pbsAndCbsRadioId',
			items : [{
				boxLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
//				translationKey: 'PROGRAM_BATCH_SECTION',
				name : 'sectionCourse',
				inputValue : 'programBatchSection',
				checked : true
			},{
				boxLabel : getCourseTxCommonTranslation('COURSE_SECTION'),
//				translationKey: 'COURSE_SECTION',
				name : 'sectionCourse',
				inputValue : 'courseSection'

			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			style:{
				marginTop:'20px !important;'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTermCBS',
				itemId : 'academicTermIdCBS',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				typeAhead : true,
				editable : false
			},{
				xtype : 'multiselectcombofield',
				fieldLabel : getCourseTxCommonTranslation('COURSE'),
				name : 'course',
				itemId : 'course_Id',
				store : 'course.AssignedPeriodCoursesFacultyStore',
				valueField: 'courseId',
				displayField: 'courseCodeName',
				typeAhead : true,
				forceSelection : true,
				allowBlank:true,
				queryParam:'name',
				minChars:3,
				maxLength:9999,
				maxSelections :9999,
				cls:'receiptHeaderMultiselect',
				//matchFieldWidth:true,
//				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				//cls: 'multiselectAcademyLocation',//for fixing auto height issue of multiselectcombofield
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{
				xtype : 'multiselectcombofield',
				fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
				name : 'downloadCourseVariantName',
				itemId : 'downloadCourseVariant_ID',
				store : 'course.coursevariants.ChildCourseVariantStore',
				displayField : 'courseVariantCode',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank:true,
				queryParam:'name',
				minChars:3,
				maxLength:9999,
				maxSelections :9999,
				cls:'receiptHeaderMultiselect',
				//matchFieldWidth:true,
				//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				//cls: 'multiselectAcademyLocation',//for fixing auto height issue of multiselectcombofield
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTermPBS',
				itemId : 'academicTermIdPBS',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				typeAhead : true,
				editable : false
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				itemId: 'program_Id',
				name: 'program',
				store:Ext.create('Academia.store.common.AssignedProgramStore'),
				displayField:'code',
				valueField: 'id',
				queryParam:'name',
				minChars:3,
				allowBlank:false,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				//forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				name : 'batch',
				itemId : 'batch_Id',
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
				displayField : 'batchName',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				disabled:true
			}]
		},
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [
				/*{
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCourseTxCommonTranslation('COURSE'),
		        	        	  name : 'programCourse_Id',
		        	        	  itemId : 'programCourse_Id',
		        	        	  store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  hidden : true
		        	          },
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  name : 'componentSection_Id',
		        	        	  itemId : 'componentSectionItemId',
		        	        	  fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
		        	        	  store : 'course.coursetopic.CourseComponentStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  hidden : true,
		        	        	  allowBlank : false
		        	          },*/
				{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('PERIOD'),
					name : 'period',
					itemId : 'period_Id',
					store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
					valueField: 'id',
					displayField: 'programPeriodName',
					typeAhead : true,
					forceSelection : true,
					allowBlank : false,
					disabled:true
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					width: 256,
					labelAlign: 'top',
					name : 'programCoursesection',
					itemId : 'programCoursesection_ID',
					store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
					displayField : 'sectionCode',
					valueField : 'id',
					typeAhead : true,
					disabled:true,
					forceSelection : true,
					allowBlank: false/*
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCourseTxCommonTranslation('SECTION'),
		        	        	  name : 'programCoursesection',
		        	        	  itemId : 'programCoursesection_ID',
		        	        	  store : 'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  disabled:true
					 */} ]
		},{
			xtype: 'fieldcontainer',
//			style:{marginTop:'23px !important',marginLeft:'-5px !important'},
			layout: 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
			items: [{
				xtype:'button',
				itemId:'studentcourseenrollmentDownload',
				text:getCommonTranslation('DOWNLOAD_TEMPLATE'),
				ui: 'CustomBtnSubmit',
				formBind:true,
				margin: '0 80 0 0'
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
});