/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.CourseEnrollmentSearchCBS', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courseenrollmentsearchcbs',
	plugins : "formlabelrequired",
	autoScroll: false,
	frame: false,
	//cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
//		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width: 256,
			/*typeAhead:true,
			forceSelection:true,*/
			queryMode:'local',
             typeAhead : false,
             forceSelection : true,
             anyMatch : true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store);
					store.load();
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			//typeAhead : true,
			//forceSelection : true,
			hidden : false,
			queryMode:'local',
             typeAhead : false,
             forceSelection : true,
             anyMatch : true,
			listeners  :{
				render : function(combo){
			    var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
					combo.bindStore(store)
					//store.load();
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'cbsProgram',
			itemId : 'cbsProgramId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'valueCode',
			valueField : 'id',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
//		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'cbsBatch',
			itemId : 'cbsBatchId',
			fieldLabel: getCommonTranslation('BATCH'),
			store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			editable : false,
			queryMode: 'local'
			
		},{
			xtype: 'customcombobox',
			name: 'cbsPeriod',
			itemId : 'cbsPeriodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			editable : false,
			queryMode: 'local'
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('COURSE_TYPE'),
//			translationKey: 'COURSE_TYPE',
			itemId:'courseType',
			name: 'COURSE_TYPE_ID',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.common.OptionMandatoryStore');
					combo.bindStore(store);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//			translationKey: 'COURSE',
			itemId: 'courseCodeId',
			name: 'COURSE_ID',
			valueField:'id',
			displayField:'value',
			allowBlank:true,
			disabled:false,
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			},
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
//			translationKey: 'COURSE_VARIANT',
			name:'COURSE_VARIENT_ID',
			itemId: 'courseVariantId',
			displayField: 'code',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true,
			allowBlank:true,
			disabled:false,
			hidden:true,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.CoruseVariantSectionStore');
					combo.bindStore(store);
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			name : 'sectionId',
			itemId : 'sectionId',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			allowBlank : true,
			queryParam:'name',
			editable : false,
//			hidden : true,
			disabled:true,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.programCourseDashboard.ParameterisedCourseSectionStore');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'facultyName',
			itemId: 'facultyItemId',
			fieldLabel:getExaminationTranslation('FACULTY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),			
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.coursetransaction.facultytopicassignment.AssignFacultyStore');
					combo.bindStore(store);
				}
			}
		}]
	},{
		xtype: 'checkboxfield',
		width: 'auto',
		labelAlign: 'right',
		itemId:'nonParamCourses',
		name: 'nonParamCourses',
		boxLabel: getCommonTranslation('VIEW_NON_PARAM_COURSE'),
//		translationKey: 'VIEW_NON_PARAM_COURSE',
		inputValue : true,
		uncheckedValue: false,
//		style:{
//		marginTop:'28px'
//		}
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		style:{
 		   'margin-left':'-64px !important' 
 	   },
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'cbsEnrollSearchBtn',
			buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			margin: '0 16 0 0'
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetButton',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
//}]
});