/**
 * @author Dharmendra.Prajapati
 * @author seshagiri.k 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.CourseEnrollmentSearchPBS', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courseenrollmentsearchpbs',
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	//cls:'customSearchPanel',
    //layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
        /*xtype: 'form',
        width: '100%',
        items: [{*/
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
			items :[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),		
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField : 'value',
				store:Ext.create('Academia.store.common.BatchIntakeYearStore'),
				valueField : 'id',
				typeAhead : true,
				editable : true,
				queryMode:'local',
             	forceSelection : true,
             	anyMatch : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				typeAhead : true,
				editable : true,
				queryMode:'local',
             	forceSelection : true,
             	anyMatch : true
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				itemId: 'programId',
				name: 'PROGRAM_ID',
				store:Ext.create('Academia.store.common.AssignedProgramStore'),
				displayField:'code',
				valueField: 'id',
				queryParam:'name',
		    	minChars:3,
				allowBlank:true,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						//forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{code}'+ 
		    	                    '</div>';
		    	                }
		    	            }
					}]
				},{
				    xtype: 'fieldcontainer',
		            width: 'auto',
		            layout: 'hbox',
		            defaults: {
		                width: 256,
		                labelAlign: 'top'
		            },
					items : [{
						 xtype: 'customcombobox',
						 fieldLabel: getCourseTxCommonTranslation('BATCH'),
						 itemId:'batchId',
						 name: 'PROGRAM_BATCH_ID',
						 store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
						 valueField: 'id',
						 displayField: 'batchName',
						 //allowBlank:false,
						 typeAhead:true,
						 //forceSelection:true,		
						 disabled:true
					},{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('PERIOD'),
						itemId:'periodId',
						name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
						store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
						valueField: 'id',
						displayField: 'programPeriodName',
						allowBlank:true,
						typeAhead:true,
						forceSelection:true	 ,
						disabled:true
					},{
						xtype : 'customcombobox',
						fieldLabel : getCourseTxCommonTranslation('SECTION'),
						width: 256,
						labelAlign: 'top',
						name : 'sectionId',
						itemId : 'programCoursection_ID',
						store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
						displayField : 'sectionCode',
						valueField : 'id',
						typeAhead : true,
						disabled:true,
						forceSelection : true
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('COURSE_TYPE'),
						itemId:'courseType',
						name: 'COURSE_TYPE_ID',
						store: 'common.OptionMandatoryStore',
						valueField: 'id',
						displayField: 'value',
						allowBlank:true,
						typeAhead:true
					},{
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
						itemId: 'courseCodeId',
						name: 'COURSE_ID',
						valueField:'id',
						displayField:'value',
						store:Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
						allowBlank:true,
						disabled:false,
						queryParam:'name',
		    			minChars:3,
						typeAhead:false,
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
		    			  listConfig: {
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{code} / {value}'+ 
		    	                    '</div>';
		    	                }
		    	            }
					}
					/*,{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
						name:'COURSE_VARIENT_ID',
						itemId: 'courseVariantId',
					    store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
						displayField: 'code',
						valueField: 'id',
						typeAhead:true,
						forceSelection:true,
						allowBlank:true,
						disabled:true
					}*/
					]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype: 'customcombobox',
						name: 'facultyName',
						itemId: 'facultyItemId',
						store : Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
						fieldLabel:getExaminationTranslation('FACULTY'),
						valueField: 'id',
						displayField: 'value',
						queryParam:'name',
						minChars:3,
						width: 256,
						typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						//hideTrigger:true,
						enableKeyEvents  : 'true',
						forceSelection : true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							},
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						}
					},{
			            xtype: 'checkboxfield',
			            width: 330,
			            labelAlign: 'right',
			            itemId:'nonParamCourses',
			            name: 'nonParamCourses',
			            boxLabel: getCommonTranslation('VIEW_NON_PARAM_COURSE'),
			            inputValue : true,
			            uncheckedValue: false,
			            style:{
                    	marginTop:'28px'
	                    }
			        }]
				},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		    		layout : {
		    			type : 'hbox'
		    		},
		    		style:{
			    		   'margin-left':'-64px !important' 
			    	   },
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'pbsEnrollSearchBtn',
		                buttonAlign: 'left',
		                formBind:true,
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		    			margin: '0 16 0 0'
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetButton',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
    	//}]
});