/**
 * 
 * @author Mahendra Singh Bhati
 */
Ext.define('Academia.view.coursetransaction.studentregistration.StudentRegistrationDocumentUploadWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.studentregistrationdocumentuploadwindow',
    title: getCommonTranslation('UPLOAD_DOCUMENT'),
    plugins: "formlabelrequired",
    autoScroll: true,
    modal: true,
    height: '30%',
    items: [{
        xtype: 'form',
        itemId: 'onlineDocumentFormItemId',
        items: [{
            xtype: 'hidden',
            itemId: 'document_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'module'
        }, {
            xtype: 'hidden',
            name: 'entityId'
        },{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('DOCUMENTS_TYPE'),
            //store: 'common.DocumentTypeStore',
            store: Ext.create('Academia.store.common.DocumentTypeStore'),
            name: 'documentType',
            displayField: 'value',
            valueField: 'id',
            hidden: true,
            editable: false,
            allowBlank: false,
            itemId: 'documentTypeCombo'
        },{
            xtype: 'hidden',
            itemId: 'isPreDefined',
            name: 'isPreDefined'
        }, {
            xtype: 'hidden',
            itemId: 'isInspectionDone',
            name: 'isInspectionDone'
        },	{
            xtype: 'hidden',
            itemId: 'documentStatus',
            name: 'status'
        },{
            xtype: 'hidden',
            itemId: 'submissionDate',
            name: 'submissionDate'
        },{
            xtype: 'hidden',
            name: 'entityType'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileFieldContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'filefield',
                itemId: 'uploadFileField',
                region: 'south',
                ui: 'CustomBtnSubmit',
                fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
                buttonText: getCommonTranslation('BROWSE'),
                allowBlank: false,
                name: 'file'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'documentFormSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'documentCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});