/*
 * @author Akshay.Kalbhor
 */
/*
 * File for adding the group item in the Advanced search criteria.
 */
Ext.define('Academia.view.criteriabuilder.SearchCriteriaGroup', {
    extend: 'Ext.form.Panel',
    alias: 'widget.searchcriteriagroup',
    cls: 'panelNoSpace cbCustomPanel',
    paddingLeft:  '0',
    marginLeft: '0',
    config: {
        searchConfigDataSource: null,
        andOrComponentValue:'AND'
    },
    layout: {
        type: 'hbox'
    },
    cls: 'tbarWithnoSpacing',
    ui: 'tbarWithnoSpacing',
    tbar: [{
    		xtype: 'label',
    		text: getCommonTranslation('ADVANCEDSEARCHUSERMODULEGROUPDEFAULTTEXT'),
    		style :{
	        	color:'#000'
			}
    		}, {
    			xtype: 'button',
    	        itemId: 'andOrComponent',
    	        text: 'all',
    	        cls: 'CustomBodyBtnSettings',
    			enableToggle: true,
    	        pressedText: getCommonTranslation('ANY'),
    	    	depressedText: getCommonTranslation('ALL'),
    	        toggleHandler: function () {
    	    		if(this.pressed) {
    	    			this.setText(this.pressedText);
    	    			this.up('form').andOrComponentValue = 'OR'; 
    	    		} else {
    	    			this.setText(this.depressedText);
    	    			this.up('form').andOrComponentValue = 'AND';
    	    		}
    	    		this.up('form').changeLogicalOperand();
    	        }
    		}, {
    			xtype: 'label',
        		text: getCommonTranslation('ADVANCEDSEARCHUSERMODULEGROUPDEFAULTTEXTHALF'),
        		style :{
    	        	color:'#000'
    			}
    		},
    		'->',
    		{
		    xtype: 'button',
		    itemId: 'lineButton',
		    cls: 'CustomBodyBtnSettings',
		    text: getCommonTranslation('ADDBUTTONTEXT'),
		    tooltip: getCommonTranslation('ADD'),
		    //width: 24,
		    handler: function() {
		    	var groupContainerPanel= this.up('panel');
		    	/*
		    	 * Code to remove the error class from the panel if present
		    	 */
		    	if(groupContainerPanel.hasCls('cbCustomErrorPanel')) {
		    		groupContainerPanel.removeCls('cbCustomErrorPanel');
		    	}
		    	groupContainerPanel.addSearchCriteriaLineItem(groupContainerPanel);
		    	this.up('form').changeLogicalOperand();
		    	this.up('form').setSaveAndSearchButtonsVisible();
		    }
		
		}, {
		    xtype: 'button',
		    itemId: 'groupButton',
		    cls: 'CustomBodyBtnSettings',
		    text: getCommonTranslation('GROUPBUTTONTEXT'),
		    tooltip: getCommonTranslation('GROUPBUTTONTOOLTIP'),
		    handler: function() {
		    	var groupContainerPanel= this.up('panel');
		    	/*
		    	 * Code to remove the error class from the panel if present
		    	 */
		    	if(groupContainerPanel.hasCls('cbCustomErrorPanel')) {
		    		groupContainerPanel.removeCls('cbCustomErrorPanel');
		    	}
		    	groupContainerPanel.addSearchCriteriaGroupItem(groupContainerPanel);
		    	this.up('form').changeLogicalOperand();
		    	this.up('form').setSaveAndSearchButtonsVisible();
		    }
		}, {
		    xtype: 'button',
		    disabled:true,
		    itemId: 'groupDeleteButton',
		    glyph: ICONGLYPH.DELETEGLYPH,
		    cls: 'CustomBodyBtnReject',
		    tooltip: getCommonTranslation('DELETETOOLTIP'),
		    handler: function() {
		    	var groupContainerPanel= this.up('panel');
		    	groupContainerPanel.close();
		    }
		}
    ],
      items: [{
		xtype: 'text',
		itemId: 'andOrComponent',
		minWidth: '27px',
		padding: '9 0 0 0'
	},{
        xtype: 'form',
        autoScroll: true,
        itemId: 'verticalPanel',
        cls: 'noBorderPane',
        margin: '0 0 0 0',
        padding: '0 0 0 0',
        flex: 1,
        layout: {
            type: 'vbox',
            align: 'stretch'
        }
    }],
    
    addSearchCriteriaGroupItem: function(groupContainerPanel) {
    	var verticalPanel = groupContainerPanel.down('panel#verticalPanel');
    	var groupRef = Ext.create('Academia.view.criteriabuilder.SearchCriteriaGroup', {"searchConfigDataSource":groupContainerPanel.searchConfigDataSource});
    	/*
    	 * Adding group reference in the vertical panel
    	 */
    	groupRef.down('#groupDeleteButton').disabled=false;
    	verticalPanel.add(groupRef);
    	return groupRef;
    },
    
    /*
     * add search criteria
	 * STEPS TO BE FOLLOWED: 
	 * Up SearchConfig Data Source
	 * Create Table Store
	 * Add Search Criteria Line Item
	*/
    addSearchCriteriaLineItem: function(lineContainerPanel) {
    	var verticalPanel = lineContainerPanel.down('panel#verticalPanel');
    	var lineRef = Ext.create('Academia.view.criteriabuilder.SearchCriteriaLineItem', {"searchConfigDataSource":lineContainerPanel.searchConfigDataSource});
    	lineRef.initializeComponent();
    	 verticalPanel.add(lineRef);
    },
    
    /*
     * function called from the Advanced Search Query Builder view.
     * called up on click of the search button.
     */
    getSearchCriteriaValue:function(){
    	var searchCriteriaItemContainer = this.down('panel#verticalPanel');
    	var andOrComponent = this.down('button#andOrComponent');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;
    	var cbSearchCriteria = new Object();
    	var searchCriterias = new Array();
    	var criteriaError=false;
    	if(searchCriteriaItems.length > 0) { 
        	var status = Ext.each(searchCriteriaItems, function(item) {
        		/*
        		 * item.getSearchCriteriaValue() is a function of the line
        		 */
        		var advancedSearchCriteria = item.getSearchCriteriaValue();
        		if(advancedSearchCriteria!=false)
        			searchCriterias.push(advancedSearchCriteria);
        		else{
        			criteriaError=true;
        			return false;
        		}
        	});
        	if(criteriaError==false)
        	{
        	if(andOrComponent.text === 'all') {
        		cbSearchCriteria.logicalOperator = 'AND';	
        	} else if (andOrComponent.text === 'any'){
        		cbSearchCriteria.logicalOperator = 'OR';
        	} else {
        		cbSearchCriteria.logicalOperator = 'AND';
        	}
        	cbSearchCriteria.type = 'LOGICAL';
        	cbSearchCriteria.searchCriterias = searchCriterias;
        	}else
        	{
        		cbSearchCriteria=false;
        	}
    	} else {
    		//Code to assign red border to the container
    		panel = searchCriteriaItemContainer.up('panel');
    		panel.addCls('cbCustomErrorPanel');
    		Ext.Error.raise(getErrorTranslation('CRITERIABUILDERGENERICERROR'));
			showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('CANNOTPERFORMSEARCHONEMPTYGROUP'));
    		return false;
    	}
    	
    	return cbSearchCriteria;
    },
    
    /*
     * function to change the logical operand.
     */
    changeLogicalOperand: function() {
    	var buttonText = this.dockedItems.items[0].items.items[1].text;
//    	console.log(buttonText)
    	//buttonText.setVisible(true);
    	var andOrComponentText = null;
    	if(buttonText == 'all') {
    		andOrComponentText = 'AND';
    	} else if(buttonText == 'any') {
    		andOrComponentText = 'OR';
    	}
    	var searchCriteriaItemContainer = this.down('panel#verticalPanel');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;
    	
    	Ext.each(searchCriteriaItems, function(childItem) {
    		//childItem.changeLogicalComponentText(groupReference.andOrComponentValue)
    		childItem.changeLogicalComponentText(andOrComponentText);
    	});
    },
    
    changeLogicalComponentText: function(logicalOperandText) {
    	this.andOrComponentValue=logicalOperandText;
    	this.dockedItems.getAt(0).items.getAt(0).setText(logicalOperandText);
    },
    
    initializeByModel: function(searchCriteriaLogicalModel) {
    	
    	var groupReference = this;
    	var verticalPanelReference =  groupReference.down('panel#verticalPanel');
    	var searchCriteriaItems  = null;
    	var andOrComponent = this.down('button#andOrComponent');
    	if(searchCriteriaLogicalModel.data!= undefined) {
    		searchCriteriaItems = searchCriteriaLogicalModel.data.searchCriterias;
    	} else {
    		searchCriteriaItems = searchCriteriaLogicalModel.searchCriterias;
    	}
    	
    	Ext.each(searchCriteriaItems, function(searchCriteriaItem) {
    		if(searchCriteriaItem.type=== 'SQL') {
    			var lineItem = Ext.create('Academia.view.criteriabuilder.SearchCriteriaLineItem', {"searchConfigDataSource":groupReference.searchConfigDataSource});
    			lineItem.createSearchLineItemByModel(searchCriteriaItem);
    			verticalPanelReference.add(lineItem);
    		} else if (searchCriteriaItem.type=== 'LOGICAL') {
    			groupReference.createSearchGroupItemByModel(searchCriteriaItem, groupReference);
    		} else {
    			Ext.error.raise(getErrorTranslation('CRITERIABUILDERGENERICERROR'));
    		}
    		
    	});
    	var logicalOperator='AND';
    	
    	if(searchCriteriaLogicalModel.data!= undefined) {
    		logicalOperator = searchCriteriaLogicalModel.data.logicalOperator;
    	}else{
    		logicalOperator = searchCriteriaLogicalModel.logicalOperator;
    	}
    	if(logicalOperator=="OR") {
			andOrComponent.setText(andOrComponent.pressedText);
			andOrComponent.up('form').andOrComponentValue = 'OR'; 
		} else {
			andOrComponent.setText(andOrComponent.depressedText);
			andOrComponent.up('form').andOrComponentValue = 'AND';
		}
	    	andOrComponent.up('form').changeLogicalOperand();
    },
    
    createSearchGroupItemByModel: function(searchCriteriaGroupItem, groupReference) {
    	var group = this.addSearchCriteriaGroupItem(groupReference);
    	group.initializeByModel(searchCriteriaGroupItem);
    },
    
    /**
     * Method to make the Save and Search buttons visible on click of any button of the group and line.
     * @author Akshay.Kalbhor
     */
    setSaveAndSearchButtonsVisible: function() {
    	var advancedSearchQueryBuilderView = this.up('panel[xtype=advancedsearchquerybuilder]');
    	var saveSearchButton = advancedSearchQueryBuilderView.down('button#SaveSearchButton');
		var searchButton = advancedSearchQueryBuilderView.down('button#searchButton');
		saveSearchButton.setVisible(true);
		searchButton.setVisible(true);
    }

    
});