/*
 * @author Ashok.Wagh
 */
Ext.define('Academia.view.criteriabuilder.simpleadvancesearch.SimpleSearchCriteriaLineItem', {
	extend : 'Ext.form.Panel',
	alias : 'widget.simplesearchcriterialineitem',
	cls: 'panelNoSpace search-entity-form',
	autoScroll: true,
	config : {
		searchConfigDataSource: null,
		group : null,
		index : 0		
	},
	margin: '0 0 0 -2',
	//padding: '0 1 0 1',
	layout : {
		type : 'hbox',
		align : 'middle',
		flex : 'alleven'
	},
	items : [/*{
		xtype: 'text',
		itemId: 'andOrComponent',
		hidden: true,
		minWidth: '27px'
	},*/{
		xtype: 'button',
	    itemId: 'lineDeleteButton',
	    cls: 'CustomBodyBtnReject',
	    glyph: ICONGLYPH.DELETEGLYPH,
	    tooltip:'Delete',
	    hidden:true,
	    handler: function() {
	    	this.up('panel').close();
	    	//TODO: disable the button if it is enabled.
	    }
	}],
	
	 /*
     * returns a Table combobox required for CB.
     */
    createSearchEntitiesTableCombo: function(tableStore, displayFields, valueFields, itemId) {
    	viewReference = this;
        var combo = Ext.create('Ext.form.ComboBox', {
            queryMode: 'local',
            allowBlank: false,
            store: tableStore,
            cls: 'cbCombo',
            width: 'auto',
           /* grow: true,
            growToLongestValue : true,*/
            //editable: true,
           // typeAhead :true,
            readOnly:true,
            displayField: displayFields,
            valueField: valueFields,
            itemId : itemId,
            padding: '2 20 0 2',
            listeners:{
                'select': function( comboReference, records, eOpts) {
                	if(records[0].raw != undefined) {
                		viewReference.populateTableColumns(comboReference, records[0].raw.wsSearchTableColumns);
                	}else {
                		while(comboReference.nextSibling()) {
                    		comboReference.up('panel').remove(comboReference.nextSibling());
                    	};
                    	var currentPanelIndex=comboReference.up('panel').index;
                    	var childPanels=comboReference.up('panel').up('panel').items.items;
                    	Ext.each(childPanels, function(childPanel) {
                    		if(childPanel.index>currentPanelIndex)
                    		{
                    			comboReference.up('panel').up('panel').remove(childPanel);
                    		}
                    	});
                		//viewReference.populateTableColumns(comboReference, this.store.data.items.pop(records[0].get(comboReference.valueField)).data.wsSearchTableColumns);
                	}
                },
                'change': function( comboReference, newValue, oldValue, eOpts) {
                	if(this.findRecordByValue(newValue).raw != undefined) {
                		viewReference.populateTableColumns(comboReference, this.findRecordByValue(newValue).raw.wsSearchTableColumns);
                	} else {
                		
                    	/* start- if invalid value typed then reset all dependent criteria*/
                		while(comboReference.nextSibling()) {
                    		comboReference.up('panel').remove(comboReference.nextSibling());
                    	};
                		
                    	var currentPanelIndex=comboReference.up('panel').index;
                    	var childPanels=comboReference.up('panel').up('panel').items.items;
                    	var childPanelsToRemove=new Array();
                    	Ext.each(childPanels, function(childPanel) {
                    		if(childPanel.index>currentPanelIndex)
                    		{
                    			//comboReference.up('panel').up('panel').remove(childPanel);
                    			childPanelsToRemove.push(childPanel);
                    		}
                    	});
                    	Ext.each(childPanelsToRemove, function(childPanel) {
                    		comboReference.up('panel').up('panel').remove(childPanel);
                    	});
                    	/*   end  */
                    	
                		//viewReference.populateTableColumns(comboReference, this.store.data.items.pop(newValue).data.wsSearchTableColumns);
                	}
                }
           }
        });
        return combo;
    },
    
    /*
     * returns a columns combobox required for CB.
     */
    createSearchEntitiesColumnsCombo: function(columnsStore, displayFields, valueFields, itemId) {
    	viewReference = this;
        var combo = Ext.create('Ext.form.ComboBox', {
            queryMode: 'local',
            allowBlank: false,
            store: columnsStore,
            cls: 'cbCombo',
            
            width: 'auto',
           /* grow: true,
            growToLongestValue : true,*/
            editable: true,
            typeAhead :true,
            displayField: displayFields,
            valueField: valueFields,
            itemId : itemId,
            padding: '2 20 0 2',
            listeners:{
                'select': function(comboReference, records, eOpts) {
                	var dataType="";
                	if(records[0] != undefined) {
                		//viewReference.populateOperators(comboReference, this.valueModels[0].data.dataType);
                		dataType=records[0].data.dataType;
                		if(records[0].data.whetherSimpleCatagory || records[0].data.whetherStandardMaster){
                			dataType="CUSTOM_CATEGORY";
                		}
                		
                	} else {
                		//viewReference.populateOperators(comboReference, this.store.data.items.pop(newValue).data.dataType);
                		dataType=this.store.data.items.pop(records[0].get(comboReference.valueField)).data.dataType;
                		if(this.store.data.items.pop(records[0].get(comboReference.valueField)).data.whetherSimpleCatagory || this.store.data.items.pop(records[0].get(comboReference.valueField)).data.whetherStandardMaster){
                			dataType="CUSTOM_CATEGORY";
                		}
                		while(comboReference.nextSibling()) {
                    		comboReference.up('panel').remove(comboReference.nextSibling());
                    	};
                    	
                	}
            		viewReference.populateOperators(comboReference, dataType);

                },
                'change': function(comboReference, newValue, oldValue, eOpts) {
                	var dataType="";
                	
                	if(this.findRecordByValue(newValue).raw != undefined) {
                		//viewReference.populateOperators(comboReference, this.valueModels[0].data.dataType);
                		dataType=this.findRecordByValue(newValue).raw.dataType;
                		if(this.findRecordByValue(newValue).raw.whetherSimpleCatagory || this.findRecordByValue(newValue).raw.whetherStandardMaster){
                			dataType="CUSTOM_CATEGORY";
                		}
                		
                	} else {
                		//viewReference.populateOperators(comboReference, this.store.data.items.pop(newValue).data.dataType);
                		//dataType=this.store.data.items.pop(newValue).data.dataType;
                		//if(this.store.data.items.pop(newValue).data.whetherSimpleCatagory || this.store.data.items.pop(newValue).data.whetherStandardMaster){
                		//	dataType="CUSTOM_CATEGORY";
                		//}
                		
                		/* start- if invalid value typed then reset all dependent criteria*/
                		while(comboReference.nextSibling()) {
                    		comboReference.up('panel').remove(comboReference.nextSibling());
                    	};
                		
                    	var currentPanelIndex=comboReference.up('panel').index;
                    	var childPanels=comboReference.up('panel').up('panel').items.items;
                    	var childPanelsToRemove=new Array();
                    	Ext.each(childPanels, function(childPanel) {
                    		if(childPanel.index>currentPanelIndex)
                    		{
                    			//comboReference.up('panel').up('panel').remove(childPanel);
                    			childPanelsToRemove.push(childPanel);
                    		}
                    	});
                    	Ext.each(childPanelsToRemove, function(childPanel) {
                    		comboReference.up('panel').up('panel').remove(childPanel);
                    	});
                    	/*   end  */
                	}
            		viewReference.populateOperators(comboReference, dataType);

                }
           }
        });
        return combo;
    },
    
    /*
     * returns a Operator combobox required for CB.
     */
    createOperatorCombo: function(comboStore, displayFields, valueFields, itemId) {
    	viewReference = this;
        var combo = Ext.create('Ext.form.ComboBox', {
            queryMode: 'local',
            allowBlank: false,
            store: comboStore,
            cls: 'cbCombo',
            width: 'auto',
            /*grow: true,
            growToLongestValue : true,*/
            editable: false,
            typeAhead :true,
            displayField: displayFields,
            valueField: valueFields,
            itemId : itemId,
            padding: '2 20 0 2',
            listeners:{
                'select': function(comboReference, records, eOpts) {
                	if(records[0] != undefined) {
                		viewReference.populateOperands(comboReference, records[0].data.noOfOperands);
                	} else {
                		while(comboReference.nextSibling()) {
                    		comboReference.up('panel').remove(comboReference.nextSibling());
                    	};
                		//viewReference.populateOperands(comboReference, this.store.data.items.pop(records[0].get(comboReference.valueField)).data.noOfOperands);
                	}
                	
                },
                'change': function(comboReference, newValue, oldValue, eOpts) {
                	if(this.findRecordByValue(newValue).raw != undefined) {
                		viewReference.populateOperands(comboReference, this.findRecordByValue(newValue).raw.noOfOperands);
                	} else {
                		/* start- if invalid value typed then reset all dependent criteria*/
                		while(comboReference.nextSibling()) {
                    		comboReference.up('panel').remove(comboReference.nextSibling());
                    	};
                		
                    	var currentPanelIndex=comboReference.up('panel').index;
                    	var childPanels=comboReference.up('panel').items.items;
                    	var childPanelsToRemove=new Array();
                    	Ext.each(childPanels, function(childPanel) {
                    		if(childPanel.index>currentPanelIndex)
                    		{
                    			//comboReference.up('panel').up('panel').remove(childPanel);
                    			childPanelsToRemove.push(childPanel);
                    		}
                    	});
                    	Ext.each(childPanelsToRemove, function(childPanel) {
                    		comboReference.up('panel').up('panel').remove(childPanel);
                    	});
                		//viewReference.populateOperands(comboReference, this.store.data.items.pop(newValue).data.noOfOperands);
                	}
                	
                }
           }
        });
        return combo;
    },
    
    initializeComponent: function(record) {
    	var tableConfigStore = Ext.create('Academia.store.criteriabuilder.TableConfigs');
    	var storeData = this.getSearchConfigDataSource().getWsSearchConfigTables();
    	tableConfigStore.add(storeData);
        var tableCombo = this.createSearchEntitiesTableCombo(tableConfigStore, 'displayCode', 'id', 'tabCombo');
        this.add(tableCombo); 
        if(tableCombo && !isEmpty(record)){
        	tableCombo.setValue(record.get('id'));
        }
    },
    
	populateTableColumns: function(comboReference, selectedTableColumns) {
    	/*
    	 *  while loop to Remove The nextsiblings if present and then add.
    	 */
    	while(comboReference.nextSibling()) {
    		comboReference.up('panel').remove(comboReference.nextSibling());
    	};
    	var columnsConfigStore = Ext.create('Academia.store.criteriabuilder.ColumnConfigs');
    	columnsConfigStore.add(selectedTableColumns);
    	
    	var columnCombo = this.createSearchEntitiesColumnsCombo(columnsConfigStore, 'displayCode', 'id', 'colCombo');
    	comboReference.up('panel').add(columnCombo); 
    },

    populateOperators: function(comboReference, operator) {
    	/*
    	 *  while loop to Remove The nextsiblings if present and then add.
    	 */
    	var lineReference = comboReference.up('panel');
    	while(comboReference.nextSibling()) {
    		comboReference.up('panel').remove(comboReference.nextSibling());
    	}
    	if(operator==='NUMBER') {
    		var integerOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('NUMBER');
			var operatorCombo = this.createOperatorCombo(integerOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='STRING') {
			var stringOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('STRING');
			var operatorCombo = this.createOperatorCombo(stringOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='BOOLEAN') {
			var booleanOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('BOOLEAN');
			var operatorCombo = this.createOperatorCombo(booleanOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='DATE') {
			var dateOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('DATE');
			var operatorCombo = this.createOperatorCombo(dateOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='ENUM') {
 	        var enumOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('ENUM');
 	        var operatorCombo = this.createOperatorCombo(enumOperatorStore, 'displayCode', 'id', 'oprCombo');
 	       lineReference.add(operatorCombo);
 	        
		} else if(operator==='CHAR') {
 	       var charOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('CHAR');
 	       var operatorCombo = this.createOperatorCombo(charOperatorStore, 'displayCode', 'id', 'oprCombo');
 	      lineReference.add(operatorCombo);
 	       
		} else if(operator==='IDENTITY') {
			var identityOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('IDENTITY');
			var operatorCombo = this.createOperatorCombo(identityOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='REF_IDENTITY') {
			 var refIdentityOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('REF_IDENTITY');
			 var operatorCombo = this.createOperatorCombo(refIdentityOperatorStore, 'displayCode', 'id', 'oprCombo');
			 lineReference.add(operatorCombo);
		} else if(operator==='CUSTOM_CATEGORY') {
 	        var enumOperatorStore = this.searchConfigDataSource.initializeOperatorStoreByOperatorName('ENUM');
 	        var operatorCombo = this.createOperatorCombo(enumOperatorStore, 'displayCode', 'id', 'oprCombo');
 	       lineReference.add(operatorCombo);
 	        
		}
    },
    
    /*
     * function to populate operands in the line. 
     * @param {comboReference} is the reference of the operator combo whose parent combo has to be fetched
     * for taking the operand datatype.
     * @param {noOfOperands} is the number of operands to be inserted in the line
     */
    populateOperands: function(comboReference, noOfOperands) {
    	/*
    	 *  while loop to Remove The nextsiblings if present and then add.
    	 */
    	while(comboReference.nextSibling()) {
    		comboReference.up('panel').remove(comboReference.nextSibling());
    	};
    	var previousElement = comboReference.previousSibling();
    	var lineReference = comboReference.up('panel');
    	var dataType = null;
    	
    	if(previousElement.valueModels[0] != undefined) {
    		dataType = previousElement.valueModels[0].data.dataType;
    		enumType = previousElement.valueModels[0].data.enumType;
    		tableColumnReff= previousElement.valueModels[0].data.tableColumnReff;
			customFieldConfigId= previousElement.valueModels[0].data.customFieldConfigId;
			columnData=previousElement.valueModels[0].data;
			if(comboReference.value==4 || comboReference.value==7){
				dataType="SPECIAL_STRING";
			}
			if(columnData.whetherSimpleCatagory){
    			dataType="SIMPLE_CATEGORY";
    		}
    		if(columnData.whetherStandardMaster){
    			dataType="STANDARD_MASTER_CATEGORY";
    		}
    		
    		this.handleOperands(dataType, noOfOperands, lineReference, comboReference,enumType,columnData);
    	} else {
    		columnData=previousElement.store.data.items.pop(previousElement.value).data;
    		dataType = previousElement.store.data.items.pop(previousElement.value).data.dataType;
    		enumType = previousElement.store.data.items.pop(previousElement.value).data.enumType;
    		if(columnData.whetherSimpleCatagory){
    			dataType="SIMPLE_CATEGORY";
    		}
    		if(columnData.whetherSimpleCatagory){
    			dataType="STANDARD_MASTER_CATEGORY";
    		}
    		this.handleOperands(dataType, noOfOperands, lineReference, comboReference,enumType,columnData);
    	}
    },
    
    handleOperands: function (dataType, noOfOperands, lineReference, comboReference,enumType,columnData) {
	    	switch(dataType) {
			case "NUMBER":
					this.handleIntegerOperands(noOfOperands, lineReference);
				break;
				
			case "STRING":
					this.handleStringOperands(noOfOperands, lineReference);
				break;
			
			case "SPECIAL_STRING":
				this.handleSpecialStringOperands(noOfOperands, lineReference,comboReference);
			break;
				
			case "BOOLEAN":
					this.handleBooleanOperands(noOfOperands, lineReference, comboReference);
				break;
				
			case "DATE":
					this.handleDateOperands(noOfOperands, lineReference);
				break;
				
			case "ENUM":
					this.handleEnum(noOfOperands, lineReference,enumType);
				break;
			case "CHAR":
					//TODO: add the handle****Operator if required.
				break;
			case "IDENTITY":
					//TODO: add the handle****Operator if required.
				break;
			case "REF_IDENTITY":
					//TODO: add the handle****Operator if required.
				break;
			case "SIMPLE_CATEGORY":
					this.handleCustomCategory(noOfOperands,lineReference,columnData);
				break;
			case "STANDARD_MASTER_CATEGORY":
					this.handleCustomCategory(noOfOperands,lineReference,columnData);
				break;
		
		}
    },
    /*
     * method to add the provided component to the container
     * @param: component is the component which should be inserted
     * @param: container is the target component in which the component should be inserted
     * @param: itemId is the id to be set for the component.
     */
    addComponentToContainer: function(component, container, booleanValue,enumType,columnData) {
    	if(component === 'datefield') {
    		var startDate = null;
        	if(component === 'datefield') {
        		startDate = Ext.create('Ext.form.field.Date');
//    			startDate.format= CONSTANTS.DATE_FORMAT;
        		//--startDate.submitFormat= CONSTANTS.SUBMIT_DATE_FORMAT;
        		startDate.submitFormat= CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
    			startDate.allowBlank= false;
    			startDate.width= 150;
    			startDate.itemId = 'operandField';
    			startDate.style = 'margin-left: 3px;'; 
    			/*startDate.grow= true;
    			startDate.growToLongestValue= true;*/
        	}
        	container.add(startDate);
    	} else if (component === 'hiddenfield') {
    		hiddenField = Ext.create('Ext.form.field.Hidden');
    		hiddenField.setValue(booleanValue);
    		hiddenField.itemId = 'operandField';
    		hiddenField.style = 'margin-left: 3px;'; 
    		container.add(hiddenField);
    	} else if(component === 'numberfield'){
    		field = Ext.create('Ext.form.field.Number');
    		field.width = 150;
    		field.itemId = 'operandField';
    		field.style = 'margin-left: 3px;'; 
    		field.width = 150;
    		field.allowBlank= false;
    		container.add(field);	
    	} else if(component === 'textfield'){
    		field = Ext.create('Ext.form.field.Text');
    		field.itemId = 'operandField';
    		field.style = 'margin-left: 3px;'; 
    		field.allowBlank= false,
    		container.add(field);	
    	}else if(component === 'enumComboBox'){
    		
    		var enumValueStore = Ext.create('Ext.data.Store', {
    		    model : 'Academia.model.genericmodels.dropdowns.EnumCombo',
    		    proxy: {
    		        type: 'rest',
    		        api: {
    		            read: SERVERURL.PICKLISTENUM_FINDALL_ENUM_VALUES+enumType//"in.serosoft.academia.common.enumeration.AcademyType"
    		        },
    		        method: 'GET',
    				reader: {
    					type:'customarrayreader'
    				}
    		    }
    		});
    		
    		field = Ext.create('Ext.form.ComboBox',{
    			store:enumValueStore,
    	    	itemId : 'enumFieldValues',
    	    	valueField:'id',
    	    	displayField:'value'
    		});
    		container.add(field);	
    	}else if(component === 'simpleCategoryComboBox'){
    		
    		 var url = SERVERURL.SIMPLE_CUSTOM_CATEGORY_DROPDOWNLIST;
    	     var  extraParam={
    	    		 customFieldConfigId:columnData.customFieldConfigId
    	     };
    		var simpleCategoryValueStore = Ext.create('Ext.data.Store', {
                fields: ['id', 'value'],
                proxy: {
                    type: 'rest',
                    api: {
                        read: url
                    },
                    reader: {
                        type: 'json'
    	            },
    	            extraParams:extraParam
                }
            });
    		
    		field = Ext.create('Ext.form.ComboBox',{
    			store:simpleCategoryValueStore,
    	    	itemId : 'simpleCategoryFieldValues',
    	    	valueField:'id',
    	    	displayField:'value',
    	    	allowBlank: false
    		});
    		container.add(field);	
    	}else if(component === 'standardMasterComboBox'){
    		
    		tableColumnReff=columnData.tableColumnReff;

    		 var url = SERVERURL.STANDARD_MASTERS_DROPDOWN;
    	     var  extraParam={
    	        		parentTableId:tableColumnReff.substring(0,tableColumnReff.indexOf("#")) ,
    	        		columnName:tableColumnReff.substring(tableColumnReff.indexOf("#")+1,tableColumnReff.length)
    	     };
    		var standardMasterValueStore = Ext.create('Ext.data.Store', {
                fields: ['id', 'value'],
                proxy: {
                    type: 'rest',
                    api: {
                        read: url
                    },
                    reader: {
                        type: 'json'
    	            },
    	            extraParams:extraParam
                }
            });
    		
    		field = Ext.create('Ext.form.ComboBox',{
    			store:standardMasterValueStore,
    	    	itemId : 'standardMasterFieldValues',
    	    	valueField:'value',
    	    	displayField:'value',
    	    	 style : 'margin-left:3px',
    	    	editable: false,
    		});
    		container.add(field);	
    	}else if(component === 'livesearchcombo'){
    		
    		
    		var this$ = this;
    		var mstore = Ext.create('Ext.data.Store', {
    			    pageSize: 5000,  
    	            remoteSort : true,
    	            fields: ['id', 'value'],
    	            autoLoad: false,
    	            proxy: {
    	                type: 'rest',
    	                actionMethods: {
    	                    create : 'POST',
    	                    read   : 'POST',
    	                    update : 'POST',
    	                    destroy: 'POST'
    	                },
    	                doRequest: function(operation, callback, scope) {
    	                    var writer  = this.getWriter(),
    	                        request = this.buildRequest(operation, callback, scope);
    	                       
    	                    if (operation.allowWrite()) {
    	                        request = writer.write(request);
    	                    }
    	                    Ext.apply(request, {
    	                        headers       : this.headers,
    	                        timeout       : this.timeout,
    	                        scope         : this,
    	                        callback      : this.createRequestCallback(request, operation, callback, scope),
    	                        method        : this.getMethod(request),
    	                        jsonData        : this.jsonData,
    	                        disableCaching: false // explicitly set it to false, ServerProxy handles caching
    	                    });

    	                    try {
    	                    	Ext.Ajax.request(request);
    	                    } catch(ex) {
    	                    	showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('UNABLETORETRIEVEDATAFROMTHESERVER'));
    	                    	Ext.Error.notify = false;
    	                		Ext.Error.ignore = true;
    	                        Ext.Error.raise(getErrorTranslation('UNABLETORETRIEVEDATAFROMTHESERVER'));
    	                        return false;
    	                    }
    	                    	               
    	                    return request;
    	                },
    	                headers: {
    	                    'Content-Type': 'application/json'
    	                },
    	                url: "rest/cb/getOperandValues",
    	        		reader : {
    	        			type : 'json',
    	        			root : 'rows',
    	        			totalProperty : 'records',
    	        			successProperty : 'success'
    	        		},
    	                writer: {
    	                  type: 'json',
    	                  encode: true
    	                  }
    	            },
    	            listeners: {
    	                  beforeload: function(store, operation,eOpts) {
    	                	  var searchCriteria = this$.up('simpleadvancedsearchquerybuilder').prepareSearchCriteria();
    	                	  
    	                	  var tableId=this$.down("#tabCombo").value;
    	                	  var columnId=this$.down("#colCombo").value;
    	                	  var operatorId=this$.down("#oprCombo").value;
    	                	  var searchstring=this$.down("#normalFieldAutoCompleteValues").getValue();
    	                	  
    	                	  var searchConfigurationTable=this$.down("#tabCombo").getStore().findRecord( "id", tableId).data;
    	                	  
    	                	  delete searchConfigurationTable.searchConfigId;
    	                	  delete searchConfigurationTable.tableId;
    	                	  
    	                	  var searchTableColumn= this$.down("#colCombo").getStore().findRecord( "id", columnId).data; 
    	                	  var prevSearchCriterias=searchCriteria.cbSearchCriteria.searchCriterias;
    	                	  var index=null;
    	                	  var count=0;
    	                	  Ext.each(prevSearchCriterias, function(sCriteria) {
    	                	  	  var advancedSearchCriteria=sCriteria.advancedSearchCriteria;
    	                		  if(advancedSearchCriteria.searchConfigEntityId==tableId && advancedSearchCriteria.searchTableColumnId==columnId && advancedSearchCriteria.searchCriteriaOperatorId==operatorId){
    	                			  if(searchstring!=undefined && searchstring!=null){
    	                			  sCriteria.advancedSearchCriteria.operands=[searchstring];
    	                			  sCriteria.advancedSearchCriteria.searchCriteriaOperatorId=1;
    	                			  }else{
    	                				  index=count;
    	                			  }
    	                		  }
    	                		  count=count+1;
    	                	  });
    	                	  if(index!=null)
    	                	  {
    	                		  delete prevSearchCriterias[index];
    	                	  }
    	                	  var newSearchCriteria={};
    	                	  newSearchCriteria.configCode=searchCriteria.configCode;
    	                	  newSearchCriteria.cbSearchCriteria=searchCriteria.cbSearchCriteria;
    	                	  newSearchCriteria.operandValueColumn  ={
    	              		        id: searchTableColumn.id,
    	            		        resultKey: searchTableColumn.columnName,
    	            		        searchConfigurationTable: searchConfigurationTable,
    	            		        searchTableColumn:searchTableColumn
    	                	  };
    	                	  store.proxy.jsonData = Ext.encode(newSearchCriteria);
    	                	  //store.proxy.jsonData = Ext.encode(this$.buildColumnToSearch());
    	                  }
    	            }
    	        });
    		
    		
    		field = Ext.create('Ext.form.ComboBox',{
    			store:mstore,
    	    	itemId : 'normalFieldAutoCompleteValues',
    	    	valueField:'value',
    	    	displayField:'value',
    	    	typeAhead: false,
    	    	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    	    	queryParam : 'term',
    	    	minChars: 3, 
    	    	remoteFilter: true,
    	    	style : 'margin-left:150px' 
//    	    	forceSelection: true,
    	    	//allowBlank: false
    		});
    		container.add(field);
    		
    	}
    	return container;
    },
     buildColumnToSearch : function(){
    	
    	var criteria={
    		    "configCode": "USER_LIST",
    		    "operandValueColumn": {
    		        "id": 1670,
    		        "resultKey": "CODE",
    		        "searchConfigurationTable": {
    		            "id": 842,
    		            "displayOrder": 2,
    		            "alias": "T8",
    		            "displayCode": "users",
    		            "isSubQuery": false,
    		            "joinType": "INNER",
    		            "availableForCriteriaSearch": true
    		        },
    		        "searchTableColumn": {
    		            "id": 7572,
    		            "virtualField": "0",
    		            "displayCode": "cb.users.code",
    		            "dataType": "STRING",
    		            "columnName": "code",
    		            "tableId": null,
    		            "enumType": null,
    		            "whetherOccupied": true,
    		            "whetherSimpleCatagory": false,
    		            "whetherStandardMaster": false,
    		            "tableColumnReff": null,
    		            "customFieldConfigId": null
    		        }
    		    },
    		    "cbSearchCriteria": {
    		        "logicalOperator": "AND",
    		        "type": "LOGICAL",
    		        "searchCriterias": [
    		            {
    		                "advancedSearchCriteria": {
    		                    "searchConfigEntityId": 842,
    		                    "searchTableColumnId": 7589,
    		                    "searchCriteriaOperatorId": 35,
    		                    "operands": [
    		                        "2015-10-20"
    		                    ]
    		                },
    		                "type": "SQL"
    		            },
    		            {
    		                "advancedSearchCriteria": {
    		                    "searchConfigEntityId": 842,
    		                    "searchTableColumnId": 7572,
    		                    "searchCriteriaOperatorId": 1,
    		                    "operands": [
    		                        "ad"
    		                    ]
    		                },
    		                "type": "SQL"
    		            }
    		        ]
    		    }
    		};
    	
    	return criteria;
    	
    },
    /*
     * method to add a start and end date field to the container.
     * performs date validations with vtypes.
     * @param: component is the component which should be inserted
     * @param: container is the target component in which the component should be inserted
     * @param: itemId is the id to be set for the component.
     */
    addDatePairToContainer : function(component, container) {
    	var startDate=null;
    	var tillDate=null;
    	if(component === 'datefield') {
    		startDate = Ext.create('Ext.form.field.Date');
        	tillDate = Ext.create('Ext.form.field.Date');
        	startDate.itemId = 'startDate';
//			startDate.format= CONSTANTS.DATE_FORMAT;
			//--startDate.submitFormat= CONSTANTS.SUBMIT_DATE_FORMAT;
    		startDate.submitFormat= CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
			startDate.vtype= 'daterange';
			startDate.endDateField='tillDate';
			startDate.allowBlank= false;
			startDate.width= 150;
			startDate.style=  {
					marginLeft : '3px'
				};
			/*startDate.grow= true;
			startDate.growToLongestValue= true;*/
			tillDate.itemId= 'tillDate';
//			tillDate.format= CONSTANTS.DATE_FORMAT;
			//--tillDate.submitFormat= CONSTANTS.SUBMIT_DATE_FORMAT;
			tillDate.submitFormat= CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
			tillDate.vtype= 'daterange';
			tillDate.startDateField='startDate';
			tillDate.allowBlank= false;
			tillDate.width= 150;
			tillDate.style=  {
				marginLeft : '3px'
			};
			
		/*	tillDate.grow= true;
			tillDate.growToLongestValue= true;*/
			
    	}
    	container.add(startDate);
    	container.add(tillDate);
    	return container;
    },
    
    /**
     * This is to add number in between
     */
    addPairComponentToContainer : function(component, container) {
    	var numberGreaterThan = null;
    	var numberLessThan = null;
    	if(component === 'numberfield') {
    		numberGreaterThan = Ext.create('Ext.form.field.Number');
    		numberLessThan = Ext.create('Ext.form.field.Number');
        	numberGreaterThan.itemId = 'operandField';
        	numberGreaterThan.width = 150;
        	numberGreaterThan.style=  {
    				marginLeft : '3px'
    			};
        	numberGreaterThan.allowBlank= false;
        	
        	numberLessThan.itemId = 'operandField';
        	numberLessThan.width= 150;
        	numberLessThan.allowBlank= false;
        	numberLessThan.style=  {
				marginLeft : '170px'
			};
    	}
    	container.add(numberGreaterThan);
    	container.add(numberLessThan);
    	return container;
    },
    getSearchCriteriaValue:function(){
    	var children = this.query('field');
    	var advancedSearchCriteria = new Object();
    	var operands = new Array();
    	Ext.each(children, function(component) {
    		var componentType = component.getItemId();
    		if(componentType === 'tabCombo') {
				advancedSearchCriteria.searchConfigEntityId = component.value;
			} else if(componentType === 'colCombo') {
				advancedSearchCriteria.searchTableColumnId = component.value;
			} else if(componentType === 'oprCombo') {
				advancedSearchCriteria.searchCriteriaOperatorId = component.value;
			} else {
				if(component.id.replace(/\d+/g, '') === "datefield-") {
    				//operands.push(Academia.utilities.date.DateHelper.formatDate(component.value));
    				operands.push(Academia.utilities.date.DateHelper.formatDateYMD(component.value));
				} else {
					operands.push(component.value);	
				}
				advancedSearchCriteria.operands = operands;
			}
    	
    	});
    	
    	var searchCriteria = new Object();
		searchCriteria.advancedSearchCriteria = advancedSearchCriteria;
		searchCriteria.type ='SQL';
    	return searchCriteria;
    },
    
    handleIntegerOperands: function(noOfOperands, lineReference) {
    	switch(noOfOperands) {
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('numberfield', lineReference);
			break;
		case 2:
				//this.addComponentToContainer('numberfield', lineReference);
				//this.addComponentToContainer('numberfield', lineReference);
				this.addPairComponentToContainer('numberfield', lineReference);
			break;
		}
    },
    handleSpecialStringOperands:function(noOfOperands, lineReference,comboReference){
    	this.addComponentToContainer('livesearchcombo', lineReference);
    },
    handleStringOperands: function(noOfOperands, lineReference) {
    	switch(noOfOperands) {
		case -1: 
			//TODO: implement tag Field as in extjs 5 example
				/*CharOperatorStore = this.getStore('Academia.store.criteriabuilder.states');
				console.log(CharOperatorStore)*/
				/*var tagField = Ext.create('Ext.form.field.Tag', {
			        store:'Academia.store.criteriabuilder.States',
			        reference: 'states',
			        displayField: 'state',
			        valueField: 'abbr',
			        filterPickList: false,
			        queryMode: 'local',
			        publishes: 'value'
		        });
				console.log(tagField)*/
				/*multiselectCombo.model= 'Academia.model.criteriabuilder.OperatorValue',
				multiselectCombo.store= CharOperatorStore;*/
				
				//multiselectCombo.multiSelect = true;
				/*multiselectCombo.doComponentLayout();*/
				//lineReference.add(tagField);
			break;
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('textfield', lineReference);
			break;
		case 2:
				this.addComponentToContainer('textfield', lineReference);
				this.addComponentToContainer('textfield', lineReference);
			break;
		}
    },
    
    handleBooleanOperands: function(noOfOperands , lineReference, comboReference) {
    	switch(noOfOperands) {
		case 0: 
			break;
		case 1:
				var booleanValue;
				/*
				 * the value returned for the true is 28
				 * false is 29
				 */
				if(comboReference.value === 28) {
					booleanValue = 'TRUE';
				} else {
					booleanValue = 'TRUE';
				}
				this.addComponentToContainer('hiddenfield', lineReference, booleanValue);
			break;
		case 2:
			break;
		}
    },
    
    handleDateOperands: function(noOfOperands , lineReference) {
    	switch(noOfOperands) {
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('datefield', lineReference);
			break;
		case 2:
				this.addDatePairToContainer('datefield', lineReference);
			break;
		}
    },
    
    handleEnum: function(noOfOperands , lineReference,enumType) {
    	switch(noOfOperands) {
    	case -1: 
			break;
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('enumComboBox', lineReference,null,enumType);
			break;
		}
    },
    
    handleCustomCategory: function(noOfOperands,lineReference,columnData) {
    	switch(noOfOperands) {
    	case -1: 
			break;
		case 0: 
			break;
		case 1: {
	    	if(columnData.whetherSimpleCatagory){
	    		this.addComponentToContainer('simpleCategoryComboBox', lineReference,null,null,columnData);
	    	}
	    	if(columnData.whetherStandardMaster){
	    		this.addComponentToContainer('standardMasterComboBox', lineReference,null,null,columnData);
	    	}
	    	break;
		} }
    },
    changeLogicalComponentText: function(logicalOperandText) {
    	var component = this.query('text#andOrComponent');
    	if(component.length=1) {
    		component[0].setText(logicalOperandText);
    		component[0].setVisible(true);
    	}
    	
    },
    
    getComponentById: function(id) {
    	switch(id) {
	    	case 'tabCombo':
	    		return this.query('combo#tabCombo')[0];
	    	break;
	    	
	    	case 'colCombo':
	    		return this.query('combo#colCombo')[0];
		    break;
		    
	    	case 'oprCombo':
	    		return this.query('combo#oprCombo')[0];
		    break;
		    
	    	case 'operandField':
	    		return this.query('field#operandField');
		    break;
		    
	    	case 'datefields':
	    		return this.query('datefield');
	    	break;
	    	
	    	case 'enumCombo':
	    		return this.query('combo#enumFieldValues')[0];
	    	break;
	    	
	    	case 'simpleCategoryCombo':
	    		return this.query('combo#simpleCategoryFieldValues')[0];
	    	break;
	    	
	    	case 'standardMasterCombo':
	    		return this.query('combo#standardMasterFieldValues')[0];
	    	break;
    	}
    	
    },
    
    /*
     * @method createSearchLineItemByModel
     * method to create the line structure which is initialized with model.
     * 
     * @param {object} searchCriteria
     */
    createSearchLineItemByModel: function(searchCriteria) {
    	var advancedSearchCriteria = searchCriteria.advancedSearchCriteria;
    	var operands = new Array();
    	operands = searchCriteria.advancedSearchCriteria.operands;
    	
    	this.initializeComponent();
    	
    	var tableCombo = this.getComponentById('tabCombo');
    	tableCombo.setValue(advancedSearchCriteria.searchConfigEntityId);
    	
    	var columnCombo = this.getComponentById('colCombo');
    	columnCombo.setValue(advancedSearchCriteria.searchTableColumnId);
    	
    	var operatorCombo = this.getComponentById('oprCombo');
    	operatorCombo.setValue(advancedSearchCriteria.searchCriteriaOperatorId);
    	
    	var operandComponentArray = this.getComponentById('operandField');
    	var i;
    	if(operandComponentArray.length == 0) {
    		operandComponentArray = this.getComponentById('datefields');
    	}
    	
    	for(i=0; i<operandComponentArray.length; i++) {
    		if(operands[i] != null || operands[i]!= undefined)
    			operandComponentArray[i].setValue(operands[i]);
    	}
    	
    	var enumCombo = this.getComponentById('enumCombo');
		if(enumCombo!=undefined){
			enumCombo.setValue(operands[i]);
			enumCombo.getStore().load();
		}
    	
    	var simpleCategoryCombo = this.getComponentById('simpleCategoryCombo');
		if(simpleCategoryCombo!=undefined){
    		simpleCategoryCombo.setValue(operands[i]);
    		simpleCategoryCombo.getStore().load();
		}
    	var standardMasterCombo = this.getComponentById('standardMasterCombo');
		if(standardMasterCombo!=undefined){
    		standardMasterCombo.setValue(operands[i]);
    		standardMasterCombo.getStore().load();
		}
		
		
		var normalFieldAutoCompleteValuesCombo = this.down('#normalFieldAutoCompleteValues');
		if(normalFieldAutoCompleteValuesCombo!=undefined){
			//normalFieldAutoCompleteValuesCombo.setValue(operands[i]);
			//normalFieldAutoCompleteValuesCombo.getStore().load();
		}
		
    }
    
	
});
