/**
 * @author sachin.bangar
 * 
 * This form is used for custom category values
 */
Ext.define('Academia.view.customcategories.CustomCategoryValuesForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.customcategoryvaluesform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'id_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'hidden',
        name: 'whetherDeleted',
        value: 'false'
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('CATEGORY_VALUE'),
            itemId : 'categoryValueField',
            name: 'subCategoryName',
            allowBlank: false
        }, {
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('DISPLAY_ORDER'),
            itemId : 'dispalyOrderField',
            name: 'displayOrder',
            allowBlank: false,
            minValue: 0
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});