/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Custom Categories values in grid 
 */
Ext.define('Academia.view.customcategories.CustomCategoryValuesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.customcategoryvaluesgrid',
    title: getCommonTranslation('LIST_OF_CUSTOM_CATEGORY_VALUES'),
    border: true,
    cls: 'centerAlignTitle',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        /*plugins: {
			ptype: 'gridviewdragdrop',
		    dragText: getCommonTranslation('CHANGE_DISPLAY_SEQUENCE') //change display sequence		      
		}*/
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('CATEGORY_VALUE'),
        dataIndex: 'subCategoryName',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('DISPLAY_ORDER'),
        dataIndex: 'displayOrder',
        flex: .3
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.customcategories.CustomCategoryValuesStore');
    }
});