/*
 * @Prathamesh.Sheth
 * 
 * This Component is used for to display custom fields of entities.   
 */
Ext.define('Academia.view.customfields.EntityCustomFieldFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.entitycustomfieldformwindow',
	title: getCommonTranslation('CUSTOM_FIELD'),//Custom Field
    autoScroll: true,
    maxHeight: 700,
    modal: true,
    items: [{
        xtype: 'form',
        itemId: 'customFieldForm',
        plugins : "formlabelrequired",
        defaults: {
        	labelAlign:'top',
        	width: 256
          },        
        items: [{
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                action: 'Submit',
                text: getCommonTranslation('SAVE'),
                itemId: 'academyFormSubmitButtonId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,               
                formBind : true		
            },{
                xtype: 'button',
                itemId: 'academyFormCancelButtonId',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',                
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});