Ext.define('Academia.view.dashboard.GrantAccessWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.grantaccesswindow',
    modal: true,
    border: true,    
    resizable: false,
    height: '65%',
    width:  '65%',
    title: getCommonTranslation('GRANT_ACCESS_TO_DASHLET'),
    items: [{
        xtype: 'grid',
        border: true,    
        autoScroll: true,
        store : 'dashboard.NotAccessibleDashletStore',
        selType: 'checkboxmodel',
        itemId: 'grantAccessGrid',
        columns: [{
            header: getCommonTranslation('DASHLET_CODE'),
            dataIndex: 'displayCode',
            sortable: true,
            flex: 1,
            renderer:function(value,meta,record){
    			if(!isNullOrEmpty(value)) {
    				return getCommonTranslation(value);
    			} else {
    				return value;
    			}                 
    		}
        }, {
            header: getCommonTranslation('DASHLET_CATEGORY'),
            dataIndex: 'category',
            sortable: true,
            flex: 1
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style :{marginLeft: '8px'},
        items: [{
            xtype: 'button',
            text: getCommonTranslation('GRANT_ACCESS'),
            itemId: 'grantAccessBtn',
            ui: 'CustomBtnSubmit',
        	scale : CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelProgramBtn',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function() {
                    this.up('window').close(); 
                }
            }
        }]
    }]
});