Ext.define('Academia.view.dashboard.OveriddenUserDashlets', {
	extend: 'Ext.form.Panel',
	alias: 'widget.overiddenuserdashlets',
	frame: true,
	cls:'userOverideDashletCls',
	autoScroll: true,
	plugins: "formlabelrequired",
	items: [{
		xtype: 'form',
		border: true,
		cls: 'customSearchPanel',
		layout: {
			type: 'hbox'
		},
		defaults: {
			style: {
				margin: '10px'
			},
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'livesearchcombo',
			name: 'userId',
			allowBlank: false,
			forceSelection: true,
			fieldLabel: getPersonModuleTranslation('USER'),
			emptyText: getCommonTranslation('TYPE_3_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			},
			itemId: 'user'
		}, {
			xtype: 'nestedJsonCombo',
			fieldLabel: getCommonTranslation('PORTAL'),
			displayField: 'portalName',
			valueField: 'id',
			editable: false,
			itemId: 'portalCombo',
			queryMode: 'local'
		},{
			xtype: 'fieldcontainer',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		hidden:true,
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				listeners:{
					click:function(cmp){
						cmp.up('form').getForm().reset();
						
					}
				}
			}]	
		}]
	}, {
		xtype: 'tabpanel',
		itemId: 'gridTabPanel',
		minWidth: 800,
		cls: 'panelNoSpace',
		plain: true,
		activeTab: 0,
		disabled: true,
		items: [{
			xtype:'panel',
			title: getCommonTranslation('USER_ACCESSIBLE_DASHLETS'),
			items:[{
				xtype: 'useraccessiblegrid'
			}]
		}, {xtype:'panel',
			title: getCommonTranslation('OVERIDDEN_USER_ACCESSIBLE_GRID'),
			items:[{
				xtype: 'overiddenuseraccessiblegrid'
				
			}
				
			]}]
	}]
});
