/**
 * @author Amit G
 */
var personalDetailsTemplate = new Ext.XTemplate('<tpl for="."><div>', 
		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
		'<tr>', 
		'<td style="color:#273043; font-weight:600; vertical-align: top; width:33%;padding-bottom: 10px;">'+ getCommonTranslation('APPLICANT_NAME') +' - </td>', 
		'<td style="padding-bottom: 10px;"><span>{applicantName}</span></td>', 
		'</tr>',
'</table></div></tpl>');

var academicDetailsTemplate = new Ext.XTemplate('<tpl for="."><div>', 
		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
		'<tr>', 
		'<td style="color:#273043; font-weight:600; vertical-align: top; width:33%;padding-bottom: 10px;">'+ getCommonTranslation('APPLICANT_NAME') +' - </td>', 
		'<td style="padding-bottom: 10px;"><span>{applicantName}</span></td>', 
		'</tr>',
'</table></div></tpl>');
Ext.define('Academia.view.dashboard.dashlets.ApplicantSearchDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.applicantsearchdashlet',
	 graphView:true,
	    layout:'card',
	    activeItem: 0, 
	    cls:'ApplicantSearchDashletCLS dashlet',
	    loadDashlet : function() {
	    	var this$=this;
	    	var userInfo = Academia.model.authentication.UserInfoModel;
	 		var portal =  userInfo.get('portalId');
	 		var applicantId = "";
	 		var personId = "";
	 		var studentCode= "";
	    	var personaldataview = this$.down("#personaldataview");
	    	var personaldataviewStore = personaldataview.getStore();
	    	personaldataviewStore.clearData();
	 			var studentField = this$.down('#applicant');
	 			if(!isNullOrEmpty(studentField.valueModels[0])){
	 				applicantId = studentField.valueModels[0].get("id");
	 	 			personId = studentField.valueModels[0].get("personId");
	 	 			studentCode=studentField.valueModels[0].get('code');
	 			} else if (personaldataviewStore.getRange().length>0){
	 				applicantId = personaldataviewStore.data.items[0].raw.id;
	 	 			personId = personaldataviewStore.data.items[0].raw.personId;
	 			}
	 		if(!isNullOrEmpty(applicantId)){
				var personaldataview = this$.down("#personaldataview");
				var personalStore = personaldataview.getStore();
	 			this.down('#pnlApplicantDetails2').setVisible(true);
	 			this.down('#noRecordFoundImagePanelItemId').setVisible(false);
				if(!isNullOrEmpty(personId)){
					personalStore.removeAll();
					personalStore.getProxy().extraParams = {
						id: applicantId 
					}
					personalStore.load({
						callback: function(rec, operation, success) {
							if (success) {
								var studentLink = Ext.ComponentQuery.query('#applicantIdLinks');
								for(var i = 0;i<studentLink.length;i++){
									var studLink = '<table cellspacing="0" cellpadding="0" border="0" style="width:100%"><tbody><tr><td style="color:#273043; font-weight:600; vertical-align: top; width:33%;">'+ getCommonTranslation('APPLICATION_ID') +' - </td><td><a href="#">' +rec[0].get('currentApplicationId')+'</a></td></tr></tbody></table>';
									studentLink[i].setValue(studLink);
									studentLink[i].responseData = rec[0];
								}
							}
						}
					});
				}
			}
	 		else{
	 			this.down('#pnlApplicantDetails2').setVisible(false);
	 			this.down('#noRecordFoundImagePanelItemId').setVisible(true);
	 		}
	    
	    },
		defaults: {
			cls:'horizontalScrollingFixed'
	    },
	    items:[{
	    	xtype:'panel',
	    	border: true,
	    	autoScroll:true,
	    	layout:'hbox',
	    	margin : 0,
	    	width:'100%',
	    	items:[{
	    		xtype: 'panel',
	    		width:'62%',
	    		layout:'vbox',
	    		itemId:'pnlApplicantDetails2',
	    		items:[{
	    			xtype : 'displayfield',
	    			itemId: 'applicantIdLinks',
	    			width:'95%',
	    			height:'30%',
	    			style:{margin:'-5px 0px 10px 0px'},
	    			listeners: {
	    				afterrender: function(inPanel) {
	    					inPanel.getEl().on("click", function(event, target) {
	    						if (event.target.tagName == 'A') {
		                        	  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		                        	  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		                        	  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
		                        	  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
		                        	  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
		                        	  Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
		                        	  Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
		                        	  Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
		                        	  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
		                        	  Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');
		                        	  var applicantsearchdashlet = inPanel.up('applicantsearchdashlet');
		    						  var studentField = applicantsearchdashlet.down('#applicant');
		    							
		    							  var record = studentField.valueModels[0];
		                        		  var tabTitle = null;
		                        		  var personId = null;
		                        		  var applicationId = null;
		                        		  var admissionId = null;
		                        		  tabTitle = record.get('code');
		                        		  personId = record.get('personId');
		                        		  applicationId = record.get('id');
		                        		  admissionId = record.get('code');

		                        		  
		                        		  var newRec = Ext.ComponentQuery.query('#applicantIdLinks')[0].responseData.raw;
		                        		  
		                        		  record.data.admissionID='';
		                        		  record.data.admissionStatus= '';
		                        		  record.data.applicationID= applicationId;
		                        		  record.data.APPLICATION_STATUS= newRec.currentStatus;
		                        		  record.data.isDirectAdmission= false;
		                        		  record.data.isEditMode= true;
		                        		  record.data.isFormSoldApplication= false;
		                        		  record.data.isMidTermAdmission= false;
		                        		  record.data.isNewApplication= false;
		                        		  record.data.isViewMode= false;
		                        		  record.data.programStatus= '';
		                        		  record.data.stageStatus= "";

		                        		  var applicationBaseController =Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
		                        		  var me=applicationBaseController;
		                        		  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
		                        		  if(applicantProfile){
		                        			  me.getContentPanel().setActiveTab(applicantProfile);        			
		                        		  }else{
		                        			  me.addContentPanelTab(tabTitle, 'applicantprofile', null, personId,applicationId,null);
		                        			  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
		                        			  if (applicantProfile) {            	
		                        				  me.setParameterForApplicantProfile(applicantProfile,record,'',false);
		                        				  me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
		                        				  me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
		                        				  var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
		                        				  me.gettingDataInSummaryGrid(applicantProfile);    
		                        				  if(!isEmpty(applicantLinkPanelObject)){
		                        					  var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
		                        					  me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);

		                        					  var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
		                        					  me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);

		                        					  var personInfoPanel=applicantProfile.down("#personInfoPanel");
		                        					  if(personInfoPanel){
		                        						  var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
		                        						  if(applicantPersonalDetails){
		                        							  personInfoPanel.setActiveTab(applicantPersonalDetails);
		                        						  }        						
		                        					  }

		                        				  }

		                        			  }
		                        		  }    	        
	    						}
	    					})
	    				}
	    			}
	    		},{
	    			xtype:'panel',
	    			border:false,
	    			frame:false,
	    			cls:'panelNoSpace',
	    			layout:'fit',
	    			width:'95%',
	    			items: [{
	    				xtype:'dataview',
	    				itemId:'personaldataview',
	    				store :'dashboard.ApplicantSearchDashletStore',
	    				tpl: academicDetailsTemplate,
	    				multiSelect:true,
	    				autoHeight:true,
	    				itemSelector:'div.innerGrid'
	    			}]
	    		}]
	    	},{
	    	xtype: 'panel',
			width: '100%',
			itemId:'noRecordFoundImagePanelItemId',
			height: '100%',
			html: '<div><div class ="studentlookupdashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
			style:{
			    left: '-12%;'
			}
	    	}]
	    }],tbar: {
	        cls: 'applicantlookupdashbordTbar',
	        style:{marginLeft:'-10px'},
	        items: [{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				fieldLabel: getCommonTranslation('APPLICANT_SEARCH'),
				labelWidth:125,
				width:'90%',
				height:'32px',
				style:{marginLeft:'15px'},
				store: 'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
				valueField: 'code',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('SEARCH_BY_APPLICATION_ID'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.minWidth = picker.minWidth-110;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
	        }]
	    }
	});
